/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import lombok.Generated;
import org.jetlinks.supports.protocol.codec.BinaryCodec;
import org.jetlinks.supports.protocol.codec.Endian;

public class TwoBytesHexFloatCodec
implements BinaryCodec<Float> {
    private final Endian endian;
    private final int offset;

    @Override
    public Float decode(byte[] payload, int offset) {
        int high = payload[offset + this.offset];
        int low = payload[offset + this.offset + 1] & 0xFF;
        if (this.endian == Endian.Little) {
            int tmp = low;
            low = high;
            high = tmp;
        }
        int fistValue = high << 8;
        int secondValue = low;
        return Float.valueOf((float)(fistValue + secondValue) / 10.0f);
    }

    @Override
    public void encode(Float part, byte[] payload, int offset) {
        int intVal = (int)(part.floatValue() * 10.0f);
        int high = intVal >> 8;
        int low = intVal & 0xFF;
        if (this.endian == Endian.Little) {
            payload[offset + this.offset] = (byte)low;
            payload[offset + this.offset + 1] = (byte)high;
        } else {
            payload[offset + this.offset] = (byte)high;
            payload[offset + this.offset + 1] = (byte)low;
        }
    }

    @Generated
    private TwoBytesHexFloatCodec(Endian endian, int offset) {
        this.endian = endian;
        this.offset = offset;
    }

    @Generated
    public static TwoBytesHexFloatCodec of(Endian endian, int offset) {
        return new TwoBytesHexFloatCodec(endian, offset);
    }
}

