/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.validator;

import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jetlinks.supports.protocol.validator.MethodInvokeDeniedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MethodDeniedClassVisitor
extends ClassVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodDeniedClassVisitor.class);
    private final Set<String> denied = new HashSet<String>();
    private final Set<String> ignoreClass = new HashSet<String>();
    static final FastThreadLocal<String> clazzName = new FastThreadLocal();
    private static final MethodDeniedClassVisitor GLOBAL = new MethodDeniedClassVisitor();

    public static MethodDeniedClassVisitor global() {
        return GLOBAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String className, InputStream classStream) {
        for (String aClass : this.ignoreClass) {
            if (!className.startsWith(aClass)) continue;
            return;
        }
        clazzName.set((Object)className);
        try {
            ClassReader classReader = new ClassReader(classStream);
            classReader.accept((ClassVisitor)this, 0);
        }
        catch (IOException e) {
            log.warn("read class {} error", (Object)className, (Object)e);
        }
        finally {
            clazzName.set(null);
        }
    }

    public void addIgnore(String ... classOrPackageName) {
        this.ignoreClass.addAll(Arrays.asList(classOrPackageName));
    }

    public void addDefaultDenied() {
        this.denied.addAll(MethodDeniedClassVisitor.GLOBAL.denied);
    }

    public void removeDenied(String method) {
        this.denied.remove(method);
    }

    public void addDenied(String method) {
        this.denied.add(method);
    }

    public void removeDenied(Class<?> clazz, String method) {
        this.removeDenied(clazz.getName() + "." + method);
    }

    public void addDenied(Class<?> clazz, String method) {
        this.addDenied(clazz.getName() + "." + method);
    }

    public MethodDeniedClassVisitor() {
        super(589824);
    }

    public MethodVisitor visitMethod(int access, final String methodName, String descriptor, String signature, String[] exceptions) {
        return new MethodVisitor(this.api){
            int line;
            {
                super(api);
                this.line = -1;
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                if (MethodDeniedClassVisitor.this.denied.contains((owner = owner.replace("/", ".")) + "." + name) || MethodDeniedClassVisitor.this.denied.contains(owner + ".*")) {
                    throw new MethodInvokeDeniedException((String)clazzName.get(), methodName, owner.replace("/", "."), name, this.line);
                }
            }

            public void visitLineNumber(int line, Label start) {
                super.visitLineNumber(line, start);
                this.line = line;
            }
        };
    }

    static {
        GLOBAL.addDenied(MethodDeniedClassVisitor.class, "*");
        GLOBAL.addDenied(Flux.class, "blockFirst");
        GLOBAL.addDenied(Flux.class, "blockLast");
        GLOBAL.addDenied(Flux.class, "toIterable");
        GLOBAL.addDenied(Flux.class, "toStream");
        GLOBAL.addDenied(Mono.class, "block");
        GLOBAL.addDenied(Mono.class, "blockOptional");
        GLOBAL.addDenied(Mono.class, "toFuture");
        GLOBAL.addDenied(UncaughtExceptionHandlers.class, "systemExit");
        GLOBAL.addDenied("reactor.core.publisher.MonoProcessor.block");
        GLOBAL.addDenied("reactor.core.publisher.MonoProcessor.blockOptional");
        GLOBAL.addDenied("cn.hutool.core.util.RuntimeUtil.*");
        GLOBAL.addDenied(System.class, "exit");
        GLOBAL.addDenied(Runtime.class, "exit");
        GLOBAL.addDenied(Runtime.class, "exec");
        GLOBAL.addDenied(Runtime.class, "halt");
        GLOBAL.addDenied(ProcessBuilder.class, "start");
        GLOBAL.addIgnore("com.google");
        GLOBAL.addIgnore("org.apache");
        GLOBAL.addIgnore("cn.hutool");
    }
}

