/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.scalecube.rpc;

import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ForbiddenException;
import io.scalecube.services.exceptions.InternalServiceException;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.exceptions.UnauthorizedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.hswebframework.web.recycler.Recycler;
import org.jetlinks.core.utils.ExceptionUtils;
import org.springframework.util.StringUtils;

public class DetailErrorMapper
implements ServiceClientErrorMapper,
ServiceProviderErrorMapper {
    static final Recycler<ByteArrayOutputStream> SHARED_OUT = Recycler.create(() -> new ByteArrayOutputStream(1024), ByteArrayOutputStream::reset, (int)64);
    private static final int DEFAULT_ERROR_CODE = 500;
    public static final DetailErrorMapper INSTANCE = new DetailErrorMapper();
    public static final String ERROR_DETAIL = "errorDetail";
    StackTraceElement[] topTrace = new StackTraceElement[0];

    void setTopTrace(StackTraceElement ... trace) {
        this.topTrace = trace;
    }

    public Throwable toError(ServiceMessage message) {
        BadRequestException error;
        ErrorData data = (ErrorData)message.data();
        int errorType = message.errorType();
        int errorCode = data.getErrorCode();
        String errorMessage = data.getErrorMessage();
        StackTraceElement[] stackTrace = DetailErrorMapper.decodeDetail(message.header(ERROR_DETAIL), this.topTrace);
        switch (errorType) {
            case 400: {
                BadRequestException badRequestException = new BadRequestException(errorCode, errorMessage);
                break;
            }
            case 401: {
                BadRequestException badRequestException = new UnauthorizedException(errorCode, errorMessage);
                break;
            }
            case 403: {
                BadRequestException badRequestException = new ForbiddenException(errorCode, errorMessage);
                break;
            }
            case 503: {
                BadRequestException badRequestException = new ServiceUnavailableException(errorCode, errorMessage);
                break;
            }
            case 500: {
                BadRequestException badRequestException = new InternalServiceException(errorCode, errorMessage);
                break;
            }
            default: {
                BadRequestException badRequestException = error = new InternalServiceException(errorCode, errorMessage);
            }
        }
        if (stackTrace != null) {
            error.setStackTrace(stackTrace);
        }
        return error;
    }

    public static StackTraceElement[] decodeDetail(String e, StackTraceElement ... top) {
        StackTraceElement[] stackTraceElementArray;
        if (!StringUtils.hasText((String)e)) {
            return null;
        }
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(e)));
        try {
            int length = input.readInt();
            StackTraceElement[] stack = Arrays.copyOf(top, top.length + length);
            for (int i = top.length; i < length + top.length; ++i) {
                String className = input.readUTF();
                String methodName = input.readUTF();
                String fileName = input.readUTF();
                int lineNumber = input.readInt();
                stack[i] = new StackTraceElement(className, methodName, StringUtils.hasText((String)fileName) ? fileName : null, lineNumber);
            }
            stackTraceElementArray = stack;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        input.close();
        return stackTraceElementArray;
    }

    public static String createDetail(StackTraceElement[] top, Throwable e) {
        StackTraceElement[] stack = ExceptionUtils.getMergedStackTrace((Throwable)e);
        if (stack.length == 0) {
            return "";
        }
        return (String)SHARED_OUT.doWith((Object)top, (Object)stack, (out, _top, _stack) -> {
            String string;
            DataOutputStream dataOut = new DataOutputStream((OutputStream)out);
            try {
                dataOut.writeInt(((StackTraceElement[])_stack).length + ((StackTraceElement[])_top).length);
                for (StackTraceElement element : _top) {
                    dataOut.writeUTF(element.getClassName());
                    dataOut.writeUTF(element.getMethodName());
                    dataOut.writeUTF(element.getFileName() == null ? "" : element.getFileName());
                    dataOut.writeInt(element.getLineNumber());
                }
                for (StackTraceElement element : _stack) {
                    dataOut.writeUTF(element.getClassName());
                    dataOut.writeUTF(element.getMethodName());
                    dataOut.writeUTF(element.getFileName() == null ? "" : element.getFileName());
                    dataOut.writeInt(element.getLineNumber());
                }
                string = Base64.getEncoder().encodeToString(out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataOut.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable ignore) {
                    return "";
                }
            }
            dataOut.close();
            return string;
        });
    }

    public ServiceMessage toMessage(String qualifier, Throwable throwable) {
        int errorCode = 500;
        int errorType = 500;
        if (throwable instanceof ServiceException) {
            errorCode = ((ServiceException)throwable).errorCode();
            if (throwable instanceof BadRequestException) {
                errorType = 400;
            } else if (throwable instanceof UnauthorizedException) {
                errorType = 401;
            } else if (throwable instanceof ForbiddenException) {
                errorType = 403;
            } else if (throwable instanceof ServiceUnavailableException) {
                errorType = 503;
            }
        }
        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElseGet(throwable::toString);
        return ServiceMessage.builder().qualifier(qualifier).header("errorType", String.valueOf(errorType)).header(ERROR_DETAIL, DetailErrorMapper.createDetail(this.topTrace, throwable)).data((Object)new ErrorData(errorCode, errorMessage)).build();
    }
}

