/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.server.monitor;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetlinks.core.server.monitor.GatewayServerMetrics;
import org.jetlinks.core.server.session.DeviceSession;

public class MicrometerGatewayServerMetrics
implements GatewayServerMetrics {
    private final String serverId;
    private final MeterRegistry registry;
    private final Map<String, AtomicLong> sessionRecord = new ConcurrentHashMap<String, AtomicLong>();

    public MicrometerGatewayServerMetrics(String serverId) {
        this(serverId, null);
    }

    public MicrometerGatewayServerMetrics(String serverId, MeterRegistry registry) {
        this.serverId = serverId;
        if (registry == null) {
            registry = Metrics.globalRegistry;
        }
        this.registry = registry;
        Gauge.builder((String)"gateway-server-session", this.sessionRecord, sessionRecord -> sessionRecord.values().stream().mapToLong(Number::longValue).sum()).tag("server", this.getServerId()).register(registry);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void reportSession(String transport, int sessionTotal) {
        this.sessionRecord.computeIfAbsent(transport, key -> new AtomicLong()).set(sessionTotal);
    }

    public void newConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void acceptedConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment(-1.0);
        this.registry.counter("gateway-server-requests-accepts", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void rejectedConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment(-1.0);
        this.registry.counter("gateway-server-requests-rejects", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void receiveFromDeviceMessage(DeviceSession session) {
        this.registry.counter("received_messages", new String[]{"transport", session.getTransport().getId(), "deviceId", session.getDeviceId(), "server", this.getServerId()}).increment(1.0);
    }
}

