/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.defaults.DefaultDeviceOperator;
import org.jetlinks.core.defaults.DefaultDeviceProductOperator;
import org.jetlinks.core.device.CompositeDeviceMessageSenderInterceptor;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperationBroker;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.ProductInfo;
import org.jetlinks.core.device.StandaloneDeviceMessageBroker;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.supports.config.InMemoryConfigStorageManager;
import org.jetlinks.supports.test.MockProtocolSupport;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InMemoryDeviceRegistry
implements DeviceRegistry {
    private final CompositeDeviceMessageSenderInterceptor interceptor = new CompositeDeviceMessageSenderInterceptor();
    private final ConfigStorageManager manager = new InMemoryConfigStorageManager();
    private final Map<String, DeviceOperator> operatorMap = new ConcurrentHashMap<String, DeviceOperator>();
    private final Map<String, DeviceProductOperator> productOperatorMap = new ConcurrentHashMap<String, DeviceProductOperator>();
    private final ProtocolSupports supports;
    private final DeviceOperationBroker handler;

    public static InMemoryDeviceRegistry create() {
        return new InMemoryDeviceRegistry();
    }

    public InMemoryDeviceRegistry() {
        this(new MockProtocolSupport(), (DeviceOperationBroker)new StandaloneDeviceMessageBroker());
    }

    public InMemoryDeviceRegistry(ProtocolSupports supports, DeviceOperationBroker handler) {
        this.supports = supports;
        this.handler = handler;
    }

    public Mono<DeviceOperator> getDevice(String deviceId) {
        return Mono.fromSupplier(() -> this.operatorMap.get(deviceId));
    }

    public Mono<DeviceProductOperator> getProduct(String productId) {
        return Mono.fromSupplier(() -> this.productOperatorMap.get(productId));
    }

    public Mono<DeviceProductOperator> getProduct(String productId, String version) {
        if (StringUtils.isEmpty((Object)version)) {
            return this.getProduct(productId);
        }
        return Mono.fromSupplier(() -> this.productOperatorMap.get(productId + ":" + version));
    }

    public Mono<DeviceOperator> register(DeviceInfo deviceInfo) {
        return Mono.defer(() -> {
            DefaultDeviceOperator operator = new DefaultDeviceOperator(deviceInfo.getId(), this.supports, this.manager, this.handler, (DeviceRegistry)this, (DeviceMessageSenderInterceptor)this.interceptor);
            this.operatorMap.put(operator.getDeviceId(), (DeviceOperator)operator);
            HashMap configs = new HashMap();
            Optional.ofNullable(deviceInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProductId()).ifPresent(conf -> configs.put(DeviceConfigKey.productId.getKey(), conf));
            Optional.ofNullable(deviceInfo.getConfiguration()).ifPresent(configs::putAll);
            return operator.setConfigs(configs).thenReturn((Object)operator);
        });
    }

    public Mono<DeviceProductOperator> register(ProductInfo productInfo) {
        return Mono.defer(() -> {
            String cacheId = StringUtils.isEmpty((Object)productInfo.getVersion()) ? productInfo.getId() : productInfo.getId() + ":" + productInfo.getVersion();
            DefaultDeviceProductOperator operator = new DefaultDeviceProductOperator(productInfo.getId(), this.supports, this.manager.getStorage(cacheId), Flux::empty);
            this.productOperatorMap.put(cacheId, (DeviceProductOperator)operator);
            HashMap configs = new HashMap();
            Optional.ofNullable(productInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(productInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(productInfo.getConfiguration()).ifPresent(configs::putAll);
            return operator.setConfigs(configs).thenReturn((Object)operator);
        });
    }

    public Mono<Void> unregisterDevice(String deviceId) {
        return Mono.justOrEmpty((Object)deviceId).map(this.operatorMap::remove).then();
    }

    public Mono<Void> unregisterProduct(String productId) {
        return Mono.justOrEmpty((Object)productId).map(this.productOperatorMap::remove).then();
    }

    public Mono<Void> unregisterProduct(String productId, String version) {
        return Mono.justOrEmpty((Object)(productId + ":" + version)).map(this.productOperatorMap::remove).then();
    }

    public void addInterceptor(DeviceMessageSenderInterceptor interceptor) {
        this.interceptor.addInterceptor(interceptor);
    }
}

