/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.plugin.internal;

import java.io.File;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.monitor.logger.Slf4jLogger;
import org.jetlinks.core.monitor.metrics.Metrics;
import org.jetlinks.core.monitor.tracer.Tracer;
import org.jetlinks.core.utils.ConverterUtils;
import org.jetlinks.plugin.core.Plugin;
import org.jetlinks.plugin.core.PluginContext;
import org.jetlinks.plugin.core.PluginEnvironment;
import org.jetlinks.plugin.core.PluginMetrics;
import org.jetlinks.plugin.core.PluginRegistry;
import org.jetlinks.plugin.core.PluginScheduler;
import org.jetlinks.plugin.core.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StaticPluginContext
implements ServiceRegistry,
PluginContext,
PluginRegistry,
PluginScheduler,
PluginEnvironment {
    private static final Logger log = LoggerFactory.getLogger(StaticPluginContext.class);
    private final Map<String, Object> services = new HashMap<String, Object>();
    private final Map<String, Object> configs = new HashMap<String, Object>();

    public StaticPluginContext withService(Object service) {
        this.services.put(service.getClass().getSimpleName(), service);
        return this;
    }

    public StaticPluginContext withService(String name, Object service) {
        this.services.put(name, service);
        return this;
    }

    public StaticPluginContext withConfig(String key, Object value) {
        this.configs.put(key, value);
        return this;
    }

    public PluginRegistry registry() {
        return this;
    }

    public ServiceRegistry services() {
        return this;
    }

    public PluginEnvironment environment() {
        return this;
    }

    public PluginMetrics metrics() {
        return new PluginMetrics(){

            public org.jetlinks.core.monitor.logger.Logger logger() {
                return new Slf4jLogger(log);
            }

            public Tracer tracer() {
                return Tracer.noop();
            }

            public Metrics metrics() {
                return Metrics.noop();
            }
        };
    }

    public PluginScheduler scheduler() {
        return this;
    }

    public File workDir() {
        return new File("target");
    }

    public Mono<Plugin> getPlugin(String type, String pluginId) {
        return Mono.empty();
    }

    public Flux<Plugin> getPlugins(String type) {
        return Flux.empty();
    }

    public Flux<Plugin> getPlugins() {
        return Flux.empty();
    }

    public Disposable interval(String name, Mono<Void> job, String cronExpression, boolean singleton) {
        return Disposables.disposed();
    }

    public Disposable interval(String name, Mono<Void> job, Duration interval, boolean singleton) {
        return Flux.interval((Duration)interval).onBackpressureDrop().concatMap(ignore -> job).subscribe();
    }

    public Disposable delay(Mono<Void> job, Duration interval) {
        return Mono.delay((Duration)interval).then(job).subscribe();
    }

    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.configs.get(key)).map(String::valueOf);
    }

    public <T> Optional<T> getProperty(String key, Class<T> type) {
        return Optional.ofNullable(this.configs.get(key)).map(e -> ConverterUtils.convert((Object)e, (Type)type));
    }

    public Map<String, Object> getProperties() {
        return this.configs;
    }

    public <T> Optional<T> getService(Class<T> type) {
        return this.services.values().stream().filter(type::isInstance).findFirst().map(type::cast);
    }

    public <T> Optional<T> getService(Class<T> type, String name) {
        return Optional.ofNullable(this.services.get(name)).map(type::cast);
    }

    public <T> List<T> getServices(Class<T> type) {
        return this.services.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }
}

