/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.schema.Column;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.jetlinks.reactor.ql.supports.ExpressionVisitorAdapter;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.reactor.ql.utils.CompareUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FilterFeature
extends Feature {
    public BiFunction<ReactorQLRecord, Object, Mono<Boolean>> createPredicate(Expression var1, ReactorQLMetadata var2);

    public static Optional<BiFunction<ReactorQLRecord, Object, Mono<Boolean>>> createPredicateByExpression(final Expression expression, final ReactorQLMetadata metadata) {
        final AtomicReference ref = new AtomicReference();
        expression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            @Override
            public void visit(net.sf.jsqlparser.expression.Function function) {
                ref.set(metadata.getFeature(FeatureId.Filter.of(function.getName())).map(filterFeature -> filterFeature.createPredicate(expression, metadata)).orElseGet(() -> {
                    Function<ReactorQLRecord, ? extends Publisher<?>> mapper = ValueMapFeature.createMapperNow((Expression)function, metadata);
                    return (record, o) -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)record))).map(CastUtils::castBoolean);
                }));
            }

            @Override
            public void visit(AndExpression expr) {
                metadata.getFeature(FeatureId.Filter.and).ifPresent(filterFeature -> ref.set(filterFeature.createPredicate((Expression)expr, metadata)));
            }

            @Override
            public void visit(CaseExpression expr) {
                Function<ReactorQLRecord, ? extends Publisher<?>> mapper = ValueMapFeature.createMapperNow((Expression)expr, metadata);
                ref.set((ctx, v) -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)ctx))).map(resp -> CompareUtils.equals(true, resp)).defaultIfEmpty((Object)false));
            }

            @Override
            public void visit(OrExpression expr) {
                metadata.getFeature(FeatureId.Filter.or).ifPresent(filterFeature -> ref.set(filterFeature.createPredicate((Expression)expr, metadata)));
            }

            @Override
            public void visit(Parenthesis value) {
                FilterFeature.createPredicateByExpression(value.getExpression(), metadata).ifPresent(ref::set);
            }

            @Override
            public void visit(Between expr) {
                metadata.getFeature(FeatureId.Filter.between).ifPresent(filterFeature -> ref.set(filterFeature.createPredicate((Expression)expr, metadata)));
            }

            @Override
            public void visit(InExpression expr) {
                metadata.getFeature(FeatureId.Filter.in).ifPresent(filterFeature -> ref.set(filterFeature.createPredicate((Expression)expr, metadata)));
            }

            @Override
            public void visit(LongValue value) {
                long val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(DoubleValue value) {
                double val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(TimestampValue value) {
                Timestamp val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(DateValue value) {
                Date val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(TimeValue value) {
                Time val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(StringValue value) {
                String val = value.getValue();
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, val)));
            }

            @Override
            public void visit(IsNullExpression value) {
                boolean not = value.isNot();
                Function<ReactorQLRecord, ? extends Publisher<?>> expr = ValueMapFeature.createMapperNow(value.getLeftExpression(), metadata);
                ref.set((row, column) -> Flux.from((Publisher)((Publisher)expr.apply((ReactorQLRecord)row))).any(r -> true).map(r -> not == r));
            }

            @Override
            public void visit(IsBooleanExpression value) {
                boolean not = value.isNot();
                boolean isTrue = value.isTrue();
                Function<ReactorQLRecord, ? extends Publisher<?>> mapper = metadata.getFeatureNow(FeatureId.ValueMap.property).createMapper(value.getLeftExpression(), metadata);
                ref.set((row, column) -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)row))).map(left -> !not == isTrue == CastUtils.castBoolean(left)));
            }

            @Override
            public void visit(Column expr) {
                Function<ReactorQLRecord, ? extends Publisher<?>> mapper = metadata.getFeatureNow(FeatureId.ValueMap.property).createMapper((Expression)expr, metadata);
                ref.set((row, column) -> Mono.just((Object)CompareUtils.equals(column, mapper.apply((ReactorQLRecord)row))));
            }

            @Override
            public void visit(NotExpression notExpression) {
                Function<ReactorQLRecord, ? extends Publisher<?>> mapper = ValueMapFeature.createMapperNow(notExpression.getExpression(), metadata);
                ref.set((row, column) -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)row))).cast(Boolean.class).map(v -> v == false));
            }

            @Override
            public void visit(NullValue value) {
                ref.set((row, column) -> Mono.just((Object)(column == null ? 1 : 0)));
            }

            @Override
            public void visit(ExistsExpression exists) {
                Function<ReactorQLRecord, ? extends Publisher<?>> mapper = ValueMapFeature.createMapperNow(exists.getRightExpression(), metadata);
                boolean not = exists.isNot();
                ref.set((row, column) -> Flux.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)row))).any(r -> true).map(r -> r != not));
            }

            @Override
            public void visit(BinaryExpression expression2) {
                metadata.getFeature(FeatureId.Filter.of(expression2.getStringExpression())).ifPresent(filterFeature -> ref.set(filterFeature.createPredicate((Expression)expression2, metadata)));
                if (ref.get() == null) {
                    metadata.getFeature(FeatureId.ValueMap.of(expression2.getStringExpression())).ifPresent(filterFeature -> {
                        Function<ReactorQLRecord, ? extends Publisher<?>> mapper = filterFeature.createMapper((Expression)expression2, metadata);
                        ref.set((row, column) -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)row))).map(v -> CompareUtils.equals(column, v)));
                    });
                }
            }

            @Override
            public void visit(ComparisonOperator expression2) {
                metadata.getFeature(FeatureId.Filter.of(expression2.getStringExpression())).map(feature -> feature.createPredicate((Expression)expression2, metadata)).ifPresent(ref::set);
            }
        });
        return Optional.ofNullable(ref.get());
    }

    public static BiFunction<ReactorQLRecord, Object, Mono<Boolean>> createPredicateNow(Expression whereExpr, ReactorQLMetadata metadata) {
        return FilterFeature.createPredicateByExpression(whereExpr, metadata).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6761\u4ef6:" + whereExpr));
    }
}

