/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.utils;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import org.jetlinks.reactor.ql.supports.ExpressionVisitorAdapter;
import org.jetlinks.reactor.ql.utils.CastUtils;

public class ExpressionUtils {
    public static Optional<Object> getSimpleValue(Expression expr) {
        final AtomicReference ref = new AtomicReference();
        expr.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            @Override
            public void visit(LongValue longValue) {
                ref.set(longValue.getValue());
            }

            @Override
            public void visit(DoubleValue doubleValue) {
                ref.set(doubleValue.getValue());
            }

            @Override
            public void visit(SignedExpression signedExpression) {
                Expression expr = signedExpression.getExpression();
                Number val = ExpressionUtils.getSimpleValue(expr).map(CastUtils::castNumber).orElseThrow(() -> new UnsupportedOperationException("unsupported simple expression:" + signedExpression));
                switch (signedExpression.getSign()) {
                    case '-': {
                        ref.set(CastUtils.castNumber(val, i -> -i.intValue(), l -> -l.longValue(), d -> -d.doubleValue(), f -> Float.valueOf(-f.floatValue()), d -> -d.doubleValue()));
                        break;
                    }
                    case '~': {
                        ref.set(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                        break;
                    }
                    default: {
                        ref.set(val);
                    }
                }
            }

            @Override
            public void visit(DateValue dateValue) {
                ref.set(dateValue.getValue());
            }

            @Override
            public void visit(TimeValue timeValue) {
                ref.set(timeValue.getValue());
            }

            @Override
            public void visit(StringValue function) {
                ref.set(function.getValue());
            }
        });
        return Optional.ofNullable(ref.get());
    }
}

