/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.filter;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class LikeFilter
implements FilterFeature {
    private static final String ID = FeatureId.Filter.of("like").getId();

    @Override
    public BiFunction<ReactorQLRecord, Object, Mono<Boolean>> createPredicate(Expression expression, ReactorQLMetadata metadata) {
        Tuple2<Function<ReactorQLRecord, Publisher<?>>, Function<ReactorQLRecord, Publisher<?>>> tuple2 = ValueMapFeature.createBinaryMapper(expression, metadata);
        Function leftMapper = (Function)tuple2.getT1();
        Function rightMapper = (Function)tuple2.getT2();
        LikeExpression like = (LikeExpression)expression;
        boolean not = like.isNot();
        return (row, column) -> Mono.zip((Mono)Mono.from((Publisher)((Publisher)leftMapper.apply(row))), (Mono)Mono.from((Publisher)((Publisher)rightMapper.apply(row))), (left, right) -> this.doTest(not, left, right));
    }

    protected boolean doTest(boolean not, Object left, Object right) {
        String strRight;
        String strLeft = String.valueOf(left);
        return not != strLeft.matches(strRight = String.valueOf(right).replace("%", ".*"));
    }

    @Override
    public String getId() {
        return ID;
    }
}

