/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.supports.ExpressionVisitorAdapter;
import reactor.core.publisher.Flux;

public interface ValueFlatMapFeature
extends Feature {
    public BiFunction<String, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createMapper(Expression var1, ReactorQLMetadata var2);

    public static BiFunction<String, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createMapperNow(Expression expr, ReactorQLMetadata metadata) {
        return ValueFlatMapFeature.createMapperByExpression(expr, metadata).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c:" + expr));
    }

    public static Optional<BiFunction<String, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>>> createMapperByExpression(Expression expr, final ReactorQLMetadata metadata) {
        final AtomicReference ref = new AtomicReference();
        expr.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            @Override
            public void visit(Function function) {
                metadata.getFeature(FeatureId.ValueFlatMap.of(function.getName())).ifPresent(feature -> ref.set(feature.createMapper((Expression)function, metadata)));
            }
        });
        return Optional.ofNullable(ref.get());
    }
}

