/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FunctionMapFeature
implements ValueMapFeature {
    int maxParamSize;
    int minParamSize;
    public Function<Flux<Object>, Publisher<Object>> mapper;
    private final String id;
    private Object defaultValue;

    public FunctionMapFeature(String function, int max, int min, Function<Flux<Object>, Publisher<?>> mapper) {
        this.maxParamSize = max;
        this.minParamSize = min;
        this.mapper = mapper;
        this.id = FeatureId.ValueMap.of(function).getId();
    }

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        if (function.getParameters() == null && this.minParamSize != 0) {
            throw new UnsupportedOperationException("\u51fd\u6570[" + expression + "]\u5fc5\u987b\u4f20\u5165\u53c2\u6570");
        }
        if (function.getParameters() == null) {
            return v -> this.mapper.apply((Flux<Object>)Flux.empty());
        }
        List parameters = function.getParameters().getExpressions();
        if (parameters.size() > this.maxParamSize || parameters.size() < this.minParamSize) {
            throw new UnsupportedOperationException("\u51fd\u6570[" + expression + "]\u53c2\u6570\u6570\u91cf\u9519\u8bef");
        }
        Function wrapper = metadata.createWrapper(expression);
        List<Function<ReactorQLRecord, Publisher<Object>>> mappers = this.createParamMappers(metadata, parameters);
        if (function.isDistinct()) {
            return v -> (Publisher)Flux.from(this.apply((ReactorQLRecord)v, mappers)).distinct().as(wrapper);
        }
        if (function.isUnique()) {
            return v -> (Publisher)CastUtils.uniqueFlux((Flux<Object>)Flux.from(this.apply((ReactorQLRecord)v, mappers))).as(wrapper);
        }
        return v -> Flux.from(this.apply((ReactorQLRecord)v, mappers));
    }

    protected List<Function<ReactorQLRecord, Publisher<Object>>> createParamMappers(ReactorQLMetadata metadata, List<Expression> parameters) {
        return parameters.stream().map(expr -> ValueMapFeature.createMapperNow(expr, metadata)).collect(Collectors.toList());
    }

    public FunctionMapFeature defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    protected Publisher<Object> apply(ReactorQLRecord record, List<Function<ReactorQLRecord, Publisher<Object>>> mappers) {
        return this.mapper.apply((Flux<Object>)Flux.fromIterable(mappers).flatMap(mp -> {
            if (this.defaultValue != null) {
                return Mono.fromDirect((Publisher)((Publisher)mp.apply(record))).defaultIfEmpty(this.defaultValue);
            }
            return (Publisher)mp.apply(record);
        }));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

