/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.utils.CompareUtils;
import reactor.core.publisher.Flux;

public class DefaultReactorQLRecord
implements ReactorQLRecord,
Comparable<DefaultReactorQLRecord> {
    private ReactorQLContext context;
    private final Map<String, Object> records;
    private final Map<String, Object> results;
    private static final String THIS_RECORD = "this";
    private String name;

    public DefaultReactorQLRecord(String name, Map<String, Object> records, Map<String, Object> results, ReactorQLContext context) {
        this.name = name;
        this.records = records instanceof ConcurrentHashMap ? records : new ConcurrentHashMap(records);
        this.results = results instanceof ConcurrentHashMap ? results : new ConcurrentHashMap(results);
        this.context = context;
    }

    public DefaultReactorQLRecord(String name, Object thisRecord, ReactorQLContext context) {
        this(context);
        if (name != null) {
            this.records.put(name, thisRecord);
        }
        this.name = name;
        if (thisRecord != null) {
            this.records.put(THIS_RECORD, thisRecord);
        }
    }

    private DefaultReactorQLRecord(ReactorQLContext context) {
        this.context = context;
        this.records = this.context.newContainer();
        this.results = this.context.newContainer();
    }

    @Override
    public Flux<Object> getDataSource(String name) {
        return this.context.getDataSource(name);
    }

    @Override
    public Optional<Object> getRecord(String name) {
        return Optional.ofNullable(this.records.get(name));
    }

    @Override
    public Object getRecord() {
        return this.records.get(THIS_RECORD);
    }

    @Override
    public ReactorQLRecord setResult(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        if (name.equals("$this") && value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (null == entry.getKey() || null == entry.getValue()) continue;
                this.results.put(String.valueOf(entry.getKey()), entry.getValue());
            }
        } else {
            this.results.put(name, value);
        }
        return this;
    }

    @Override
    public ReactorQLRecord setResults(Map<String, Object> values) {
        values.forEach(this::setResult);
        return this;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.results;
    }

    @Override
    public ReactorQLRecord addRecord(String name, Object record) {
        if (name == null || record == null) {
            return this;
        }
        this.records.put(name, record);
        return this;
    }

    @Override
    public ReactorQLRecord addRecords(Map<String, Object> records) {
        records.forEach(this::addRecord);
        return this;
    }

    @Override
    public Map<String, Object> getRecords(boolean all) {
        if (all) {
            return this.records;
        }
        return Maps.filterKeys(this.records, k -> !Objects.equals(THIS_RECORD, k));
    }

    @Override
    public ReactorQLRecord removeRecord(String name) {
        if (name == null) {
            return this;
        }
        this.records.remove(name);
        return this;
    }

    @Override
    public ReactorQLRecord putRecordToResult() {
        Object record = this.getRecord();
        if (record instanceof Map) {
            this.setResults((Map)record);
            return this;
        }
        this.setResult(THIS_RECORD, record);
        return this;
    }

    @Override
    public ReactorQLRecord resultToRecord(String name) {
        DefaultReactorQLRecord record = new DefaultReactorQLRecord(this.context);
        record.name = name;
        record.records.putAll(this.records);
        ConcurrentHashMap<String, Object> thisRecord = new ConcurrentHashMap<String, Object>(this.results);
        if (null != name && !record.records.containsKey(name)) {
            record.records.put(name, thisRecord);
        }
        record.records.put(THIS_RECORD, thisRecord);
        return record;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultReactorQLRecord that = (DefaultReactorQLRecord)o;
        return Objects.equals(this.getRecord(), that.getRecord());
    }

    public int hashCode() {
        return Objects.hash(this.getRecord());
    }

    @Override
    public int compareTo(DefaultReactorQLRecord o) {
        return CompareUtils.compare(this.records, o.records);
    }

    @Override
    public ReactorQLRecord copy() {
        DefaultReactorQLRecord record = new DefaultReactorQLRecord(this.context);
        record.results.putAll(this.results);
        record.records.putAll(this.records);
        record.context = this.context;
        record.name = this.name;
        return record;
    }

    public String toString() {
        return String.valueOf(this.asMap());
    }

    @Override
    public ReactorQLContext getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

