/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public interface ReactorQLMetadata {
    public <T extends Feature> Optional<T> getFeature(FeatureId<T> var1);

    public Optional<Object> getSetting(String var1);

    default public void setConcurrency(int concurrency) {
        this.setting("concurrency", concurrency);
    }

    default public int getConcurrency() {
        return this.getSetting("concurrency").map(CastUtils::castNumber).orElse(Queues.SMALL_BUFFER_SIZE).intValue();
    }

    default public boolean isCheckpoint() {
        return this.getSetting("checkpoint").map(CastUtils::castBoolean).orElse(false);
    }

    default public <S, T> Flux<T> flatMap(Flux<S> source, Function<S, ? extends Publisher<? extends T>> mapper) {
        if (this.getConcurrency() <= 1) {
            return source.concatMap(mapper, 0);
        }
        return source.flatMap(mapper, this.getConcurrency());
    }

    public ReactorQLMetadata setting(String var1, Object var2);

    public PlainSelect getSql();

    public void release();

    default public <T extends Feature> T getFeatureNow(FeatureId<T> featureId) {
        return this.getFeatureNow(featureId, featureId::getId);
    }

    default public <T extends Feature> T getFeatureNow(FeatureId<T> featureId, Supplier<String> errorMessage) {
        return (T)((Feature)this.getFeature(featureId).orElseThrow(() -> new UnsupportedOperationException("unsupported feature: " + (String)errorMessage.get())));
    }

    public Collection<Feature> getFeatures();

    default public <T extends Publisher<? extends R>, R> Function<T, T> createWrapper(Object expr) {
        if (!this.isCheckpoint()) {
            return Function.identity();
        }
        String checkpoint = String.valueOf(expr);
        return v -> v instanceof Mono ? Mono.from((Publisher)v).checkpoint(checkpoint) : Flux.from((Publisher)v).checkpoint(checkpoint);
    }
}

