/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.from;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.TableFunction;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FromFeature;
import org.jetlinks.reactor.ql.utils.ExpressionUtils;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class CombineSelectFeature
implements FromFeature {
    private static final String ID = FeatureId.From.of("combine").getId();

    @Override
    public Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapper(FromItem fromItem, ReactorQLMetadata metadata) {
        TableFunction table = (TableFunction)fromItem;
        net.sf.jsqlparser.expression.Function function = table.getFunction();
        List<Expression> from = ExpressionUtils.getFunctionParameter(function);
        if (CollectionUtils.isEmpty(from)) {
            throw new IllegalArgumentException("Number of function parameter must not be empty!" + fromItem);
        }
        String alias = table.getAlias() == null ? null : table.getAlias().getName();
        LinkedHashMap<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>> mappers = new LinkedHashMap<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>>();
        int index = 0;
        for (Expression expression : from) {
            if (!(expression instanceof FromItem)) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684from\u8868\u8fbe\u5f0f:" + expression);
            }
            String exprAlias = ((FromItem)expression).getAlias() == null ? "$" + index : ((FromItem)expression).getAlias().getName();
            mappers.put(exprAlias, FromFeature.createFromMapperByFrom((FromItem)expression, metadata));
            ++index;
        }
        return this.create(alias, mappers);
    }

    protected Function<ReactorQLContext, Flux<ReactorQLRecord>> create(String alias, Map<String, Function<ReactorQLContext, Flux<ReactorQLRecord>>> mappers) {
        return ctx -> Flux.combineLatest((Iterable)Collections2.transform(mappers.entrySet(), e -> ((Flux)((Function)e.getValue()).apply(ctx)).map(record -> Tuples.of(e.getKey(), (Object)record))), (int)mappers.size(), zipResult -> {
            HashMap val = Maps.newHashMapWithExpectedSize((int)((Object[])zipResult).length);
            ReactorQLRecord record = ReactorQLRecord.newRecord(alias, val, ctx);
            for (Object o : zipResult) {
                Tuple2 tp2 = (Tuple2)o;
                String name = ((ReactorQLRecord)tp2.getT2()).getName() == null ? (String)tp2.getT1() : ((ReactorQLRecord)tp2.getT2()).getName();
                val.put(name, ((ReactorQLRecord)tp2.getT2()).getRecord());
            }
            return record;
        });
    }

    @Override
    public String getId() {
        return ID;
    }
}

