/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;

public class CompareUtils {
    public static int compare(Object source, Object target) {
        if (Objects.equals(source, target)) {
            return 0;
        }
        if (source == null || target == null) {
            return -1;
        }
        if (source.equals(target)) {
            return 0;
        }
        if (source.getClass() == target.getClass() && source instanceof Comparable) {
            return ((Comparable)source).compareTo(target);
        }
        if (source instanceof Instant) {
            source = Date.from((Instant)source);
        }
        if (target instanceof Instant) {
            target = Date.from((Instant)target);
        }
        if (source instanceof LocalDateTime) {
            source = Date.from(((LocalDateTime)source).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (target instanceof LocalDateTime) {
            target = Date.from(((LocalDateTime)target).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (source instanceof LocalDate) {
            source = Date.from(((LocalDate)source).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (target instanceof LocalDate) {
            target = Date.from(((LocalDate)target).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (source instanceof LocalTime) {
            source = Date.from(LocalDateTime.of(LocalDate.now(), (LocalTime)source).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (target instanceof LocalTime) {
            target = Date.from(LocalDateTime.of(LocalDate.now(), (LocalTime)target).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (source instanceof Date) {
            return CompareUtils.compare((Date)source, target);
        }
        if (target instanceof Date) {
            return -CompareUtils.compare((Date)target, source);
        }
        if (source.getClass().isEnum()) {
            return CompareUtils.compare((Enum)source, target);
        }
        if (target.getClass().isEnum()) {
            return -CompareUtils.compare((Enum)target, source);
        }
        if (source instanceof Number) {
            return CompareUtils.compare((Number)source, target);
        }
        if (target instanceof Number) {
            return -CompareUtils.compare((Number)target, source);
        }
        if (source instanceof CharSequence) {
            return CompareUtils.compare(String.valueOf(source), target);
        }
        if (target instanceof CharSequence) {
            return -CompareUtils.compare(String.valueOf(target), source);
        }
        if (source instanceof Boolean || target instanceof Boolean) {
            return CastUtils.castBoolean(target) == CastUtils.castBoolean(source) ? 0 : -1;
        }
        return -1;
    }

    public static boolean equals(Object source, Object target) {
        try {
            return CompareUtils.compare(source, target) == 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static int compare(Number number, Object target) {
        return CompareUtils.compare(number, CastUtils.castNumber(target, ignore -> null));
    }

    private static int compare(BigDecimal number, Number target) {
        if (target instanceof BigDecimal) {
            return number.compareTo((BigDecimal)target);
        }
        if (target instanceof BigInteger) {
            return number.compareTo(new BigDecimal((BigInteger)target));
        }
        return number.compareTo(BigDecimal.valueOf(target.doubleValue()));
    }

    private static int compare(BigInteger number, Number target) {
        if (target instanceof BigDecimal) {
            return number.compareTo(((BigDecimal)target).toBigInteger());
        }
        if (target instanceof BigInteger) {
            return number.compareTo((BigInteger)target);
        }
        return number.compareTo(BigInteger.valueOf(target.longValue()));
    }

    public static int compare(Number number, Number target) {
        if (number == null && target == null) {
            return 0;
        }
        if (number != null && target == null) {
            return 1;
        }
        if (number == null) {
            return -1;
        }
        if (number instanceof BigDecimal) {
            return CompareUtils.compare((BigDecimal)number, target);
        }
        if (target instanceof BigDecimal) {
            return -CompareUtils.compare((BigDecimal)target, number);
        }
        if (number instanceof BigInteger) {
            return CompareUtils.compare((BigInteger)number, target);
        }
        if (target instanceof BigInteger) {
            return -CompareUtils.compare((BigInteger)target, number);
        }
        return Double.compare(number.doubleValue(), target.doubleValue());
    }

    private static int compare(Enum<?> e, Object target) {
        if (target instanceof Number) {
            return Integer.compare(e.ordinal(), ((Number)target).intValue());
        }
        return e.name().compareToIgnoreCase(String.valueOf(target));
    }

    private static int compare(String string, Object target) {
        return string.compareTo(String.valueOf(target));
    }

    private static int compare(Date date, Object target) {
        try {
            return date.compareTo(CastUtils.castDate(target));
        }
        catch (Exception ignore) {
            return -1;
        }
    }

    public static boolean contains(Collection<Object> left, Object val) {
        if (val instanceof Collection) {
            for (Object leftVal : left) {
                if (!(leftVal instanceof Collection) || !CollectionUtils.isEqualCollection((Collection)((Collection)leftVal), (Collection)((Collection)val))) continue;
                return true;
            }
        }
        if (val instanceof HashMap) {
            for (Object leftVal : left) {
                if (!Maps.difference((Map)((Map)leftVal), (Map)((Map)val)).areEqual()) continue;
                return true;
            }
        }
        return left.contains(val);
    }
}

