/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.Map;
import java.util.Optional;
import org.jetlinks.reactor.ql.DefaultReactorQLRecord;
import org.jetlinks.reactor.ql.ReactorQLContext;
import reactor.core.publisher.Flux;

public interface ReactorQLRecord {
    public ReactorQLContext getContext();

    public String getName();

    public Flux<Object> getDataSource(String var1);

    public Optional<Object> getRecord(String var1);

    public Object getRecord();

    public ReactorQLRecord putRecordToResult();

    public ReactorQLRecord setResult(String var1, Object var2);

    public ReactorQLRecord setResults(Map<String, Object> var1);

    public Map<String, Object> asMap();

    public ReactorQLRecord resultToRecord(String var1);

    public ReactorQLRecord addRecord(String var1, Object var2);

    public ReactorQLRecord addRecords(Map<String, Object> var1);

    public Map<String, Object> getRecords(boolean var1);

    public ReactorQLRecord removeRecord(String var1);

    public static ReactorQLRecord newRecord(String name, Object row, ReactorQLContext context) {
        if (row instanceof DefaultReactorQLRecord) {
            DefaultReactorQLRecord record = (DefaultReactorQLRecord)row;
            if (null != name) {
                record.setName(name);
                record.addRecord(name, record.getRecord());
            }
            return record;
        }
        return new DefaultReactorQLRecord(name, row, context);
    }
}

