/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.utils;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.utils.time.DateFormatter;

public class CastUtils {
    public static boolean castBoolean(Object value) {
        if (Boolean.TRUE.equals(value)) {
            return true;
        }
        String strVal = String.valueOf(value);
        return "true".equalsIgnoreCase(strVal) || "y".equalsIgnoreCase(strVal) || "ok".equalsIgnoreCase(strVal) || "yes".equalsIgnoreCase(strVal) || "1".equalsIgnoreCase(strVal);
    }

    public static Map<Object, Object> castMap(List<Object> list) {
        return CastUtils.castMap(list, Function.identity(), Function.identity());
    }

    public static <K, V> Map<K, V> castMap(List<Object> list, Function<Object, K> keyMapper, Function<Object, V> valueMapper) {
        int size = list.size();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(size);
        for (int i = 0; i < size / 2; ++i) {
            map.put(keyMapper.apply(list.get(i * 2)), valueMapper.apply(list.get(i * 2 + 1)));
        }
        return map;
    }

    public static List<Object> castArray(Object value) {
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public static String castString(Object val) {
        if (val instanceof byte[]) {
            return new String((byte[])val);
        }
        if (val instanceof char[]) {
            return new String((char[])val);
        }
        return String.valueOf(val);
    }

    public static Number castNumber(Object value, Function<Integer, Number> integerMapper, Function<Long, Number> longMapper, Function<Double, Number> doubleMapper, Function<Float, Number> floatMapper, Function<Number, Number> defaultMapper) {
        Number number = CastUtils.castNumber(value);
        if (number instanceof Integer) {
            return integerMapper.apply((Integer)number);
        }
        if (number instanceof Long) {
            return longMapper.apply((Long)number);
        }
        if (number instanceof Double) {
            return doubleMapper.apply((Double)number);
        }
        if (number instanceof Float) {
            return floatMapper.apply((Float)number);
        }
        return defaultMapper.apply(number);
    }

    public static Number castNumber(Object value) {
        if (value instanceof CharSequence) {
            String stringValue = String.valueOf(value);
            if (stringValue.startsWith("0x")) {
                return Long.parseLong(stringValue.substring(2), 16);
            }
            DateFormatter dateFormatter = DateFormatter.getFormatter((String)stringValue);
            if (null != dateFormatter) {
                return dateFormatter.format(stringValue).getTime();
            }
            try {
                BigDecimal decimal = new BigDecimal(stringValue);
                if (decimal.scale() == 0) {
                    return decimal.longValue();
                }
                return decimal.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Character) {
            return (int)((Character)value).charValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        throw new UnsupportedOperationException("can not cast to number:" + value);
    }

    public static Date castDate(Object value) {
        Date date;
        if (value instanceof String && null != (date = DateFormatter.fromString((String)((String)value)))) {
            return date;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof Instant) {
            value = Date.from((Instant)value);
        }
        if (value instanceof LocalDateTime) {
            value = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalDate) {
            value = Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new UnsupportedOperationException("can not cast to date:" + value);
    }

    public static Duration parseDuration(String timeString) {
        char[] all = timeString.replace("ms", "S").toCharArray();
        if (all[0] == 'P' || all[0] == '-' && all[1] == 'P') {
            return Duration.parse(timeString);
        }
        Duration duration = Duration.ofSeconds(0L);
        char[] tmp = new char[32];
        int numIndex = 0;
        for (char c : all) {
            if (c == '-' || c >= '0' && c <= '9') {
                tmp[numIndex++] = c;
                continue;
            }
            long val = new BigDecimal(tmp, 0, numIndex).longValue();
            numIndex = 0;
            Duration plus = null;
            if (c == 'D' || c == 'd') {
                plus = Duration.ofDays(val);
            } else if (c == 'H' || c == 'h') {
                plus = Duration.ofHours(val);
            } else if (c == 'M' || c == 'm') {
                plus = Duration.ofMinutes(val);
            } else if (c == 's') {
                plus = Duration.ofSeconds(val);
            } else if (c == 'S') {
                plus = Duration.ofMillis(val);
            } else if (c == 'W' || c == 'w') {
                plus = Duration.ofDays(val * 7L);
            }
            if (plus == null) continue;
            duration = duration.plus(plus);
        }
        return duration;
    }
}

