/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.task;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.jetlinks.rule.engine.api.Logger;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scope.ContextScope;
import org.jetlinks.rule.engine.api.scope.FlowScope;
import org.jetlinks.rule.engine.api.scope.GlobalScope;
import org.jetlinks.rule.engine.api.scope.NodeScope;
import org.jetlinks.rule.engine.api.task.Input;
import org.jetlinks.rule.engine.api.task.Output;
import reactor.core.publisher.Mono;

public interface ExecutionContext {
    public String getInstanceId();

    public Logger getLogger();

    public ScheduleJob getJob();

    public <T> Mono<T> fireEvent(@Nonnull String var1, @Nonnull RuleData var2);

    public <T> Mono<T> onError(@Nullable Throwable var1, @Nullable RuleData var2);

    public Input getInput();

    public Output getOutput();

    public Mono<Void> shutdown(String var1, String var2);

    public RuleData newRuleData(Object var1);

    public void onShutdown(Runnable var1);

    public boolean isDebug();

    public GlobalScope global();

    default public <T> Mono<T> onError(@NotNull Supplier<Throwable> e, @Nullable RuleData sourceData) {
        return Mono.defer(() -> this.onError((Throwable)e.get(), sourceData));
    }

    default public ContextScope scope(String id) {
        return this.flow().context(id);
    }

    default public ContextScope scope(RuleData ruleData) {
        return this.scope(ruleData.getContextId());
    }

    default public NodeScope node() {
        return this.node(this.getJob().getNodeId());
    }

    default public NodeScope node(String id) {
        return this.flow().node(id);
    }

    default public FlowScope flow() {
        return this.flow(this.getInstanceId());
    }

    default public FlowScope flow(String id) {
        return this.global().flow(id);
    }
}

