/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.rule.engine.api.model.NodeType;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;

public class RuleNodeModel {
    private String id;
    private String ruleId;
    private String name;
    private String description;
    private String executor;
    private NodeType nodeType = NodeType.MAP;
    private SchedulingRule schedulingRule;
    private boolean end;
    private boolean start;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private List<RuleLink> events = new ArrayList<RuleLink>();
    private List<RuleLink> inputs = new ArrayList<RuleLink>();
    private List<RuleLink> outputs = new ArrayList<RuleLink>();
    private boolean parallel;

    public RuleNodeModel addConfiguration(String key, Object value) {
        this.configuration.put(key, value);
        return this;
    }

    public List<RuleLink> getEvents(String type) {
        return this.events.stream().filter(link -> type.equals(link.getType())).collect(Collectors.toList());
    }

    public boolean isStartNode() {
        return this.start || this.inputs == null || this.inputs.isEmpty();
    }

    public boolean isEndNode() {
        return this.end || this.outputs == null || this.outputs.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutor() {
        return this.executor;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public boolean isEnd() {
        return this.end;
    }

    public boolean isStart() {
        return this.start;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public List<RuleLink> getEvents() {
        return this.events;
    }

    public List<RuleLink> getInputs() {
        return this.inputs;
    }

    public List<RuleLink> getOutputs() {
        return this.outputs;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setEvents(List<RuleLink> events) {
        this.events = events;
    }

    public void setInputs(List<RuleLink> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<RuleLink> outputs) {
        this.outputs = outputs;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }
}

