/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults.scope;

import java.util.concurrent.atomic.AtomicReference;
import org.jetlinks.rule.engine.api.scope.ScropeCounter;
import reactor.core.publisher.Mono;

public class InMemoryScopeCounter
implements ScropeCounter {
    AtomicReference<Double> ref = new AtomicReference<Double>(0.0);

    @Override
    public Mono<Double> inc(double n) {
        return Mono.just((Object)this.ref.updateAndGet(v -> v + n));
    }

    @Override
    public Mono<Double> dec(double n) {
        return Mono.just((Object)this.ref.updateAndGet(v -> v - n));
    }

    @Override
    public Mono<Double> get() {
        return Mono.just((Object)this.ref.get());
    }

    @Override
    public Mono<Double> set(double value) {
        return this.getAndSet(value);
    }

    @Override
    public Mono<Double> setAndGet(double value) {
        return Mono.just((Object)this.ref.updateAndGet(v -> value));
    }

    @Override
    public Mono<Double> getAndSet(double value) {
        return Mono.just((Object)this.ref.getAndSet(value));
    }
}

