/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.List;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.Output;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EventBusOutput
implements Output {
    private static final Logger log = LoggerFactory.getLogger(EventBusOutput.class);
    private final String instanceId;
    private final EventBus eventBus;
    private final List<ScheduleJob.Output> outputs;
    private final ConditionEvaluator evaluator;

    @Override
    public Mono<Boolean> write(Publisher<RuleData> dataStream) {
        return Flux.from(dataStream).flatMap(data -> Flux.fromIterable(this.outputs).filterWhen(output -> Mono.fromCallable(() -> this.evaluator.evaluate(output.getCondition(), (RuleData)data)).onErrorResume(error -> {
            log.warn(error.getMessage(), error);
            return Mono.just((Object)false);
        })).flatMap(out -> this.eventBus.publish(this.createTopic(out.getOutput()), data))).then(Mono.just((Object)true));
    }

    @Override
    public Mono<Void> write(String nodeId, Publisher<RuleData> data) {
        return this.eventBus.publish(this.createTopic(nodeId), data).then();
    }

    private String createTopic(String node) {
        return RuleConstants.Topics.input(this.instanceId, node);
    }

    public EventBusOutput(String instanceId, EventBus eventBus, List<ScheduleJob.Output> outputs, ConditionEvaluator evaluator) {
        this.instanceId = instanceId;
        this.eventBus = eventBus;
        this.outputs = outputs;
        this.evaluator = evaluator;
    }
}

