/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.function.BiConsumer;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutableTaskExecutor;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public abstract class AbstractTaskExecutor
implements ExecutableTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskExecutor.class);
    protected ExecutionContext context;
    protected Task.State state = Task.State.shutdown;
    protected Disposable disposable;
    private BiConsumer<Task.State, Task.State> stateListener = (from, to) -> log.debug("task [{}] state changed from {} to {}.", new Object[]{this.context.getJob(), from, to});

    public AbstractTaskExecutor(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public abstract String getName();

    protected abstract Disposable doStart();

    protected void changeState(Task.State state) {
        this.state = state;
        this.stateListener.accept(this.state, this.state);
    }

    @Override
    public void start() {
        if (this.state == Task.State.running && !this.disposable.isDisposed()) {
            return;
        }
        this.disposable = this.doStart();
        this.changeState(Task.State.running);
    }

    @Override
    public void reload() {
    }

    @Override
    public void pause() {
        this.changeState(Task.State.paused);
    }

    @Override
    public void shutdown() {
        this.changeState(Task.State.shutdown);
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    @Override
    public void onStateChanged(BiConsumer<Task.State, Task.State> listener) {
        this.stateListener = this.stateListener.andThen(listener);
    }

    @Override
    public void validate() {
    }

    @Override
    public Mono<Void> execute(RuleData ruleData) {
        return this.context.getOutput().write(ruleData).then();
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    @Override
    public Task.State getState() {
        return this.state;
    }
}

