/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;

public class RuleModel {
    private String id;
    private String name;
    private String type;
    private String description;
    private SchedulingRule schedulingRule;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private List<RuleLink> events = new ArrayList<RuleLink>();
    private List<RuleNodeModel> nodes = new ArrayList<RuleNodeModel>();

    public List<RuleLink> getEvents(String type) {
        return this.events.stream().filter(link -> type.equals(link.getType())).collect(Collectors.toList());
    }

    public Optional<RuleNodeModel> getNode(String nodeId) {
        return this.nodes.stream().filter(model -> model.getId().equals(nodeId)).findFirst();
    }

    public RuleModel addConfiguration(String key, Object value) {
        this.configuration.put(key, value);
        return this;
    }

    public Optional<RuleNodeModel> getStartNode() {
        return this.nodes.stream().filter(RuleNodeModel::isStart).findFirst();
    }

    public List<RuleNodeModel> getEndNodes() {
        return this.nodes.stream().filter(RuleNodeModel::isEnd).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public List<RuleLink> getEvents() {
        return this.events;
    }

    public List<RuleNodeModel> getNodes() {
        return this.nodes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setEvents(List<RuleLink> events) {
        this.events = events;
    }

    public void setNodes(List<RuleNodeModel> nodes) {
        this.nodes = nodes;
    }
}

