/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.rule.engine.api.model.Condition;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;

public class ScheduleJob
implements Serializable {
    private static final long serialVersionUID = -1L;
    @Nonnull
    private String instanceId;
    @Nonnull
    private String ruleId;
    @Nonnull
    private String nodeId;
    @Nonnull
    private String modelType;
    private String name;
    @Nonnull
    private String executor;
    private Map<String, Object> configuration;
    private Map<String, Object> ruleConfiguration;
    private List<String> inputs = new ArrayList<String>();
    private List<Event> events = new ArrayList<Event>();
    private List<Event> eventOutputs = new ArrayList<Event>();
    private List<Output> outputs = new ArrayList<Output>();
    private Map<String, Object> context = new HashMap<String, Object>();
    private SchedulingRule schedulingRule;

    public Optional<Object> getRuleConfiguration(String key) {
        if (MapUtils.isEmpty(this.ruleConfiguration)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.ruleConfiguration.get(key));
    }

    public Optional<Object> getConfiguration(String key) {
        if (MapUtils.isEmpty(this.configuration)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.configuration.get(key));
    }

    public String toString() {
        return this.instanceId + ":" + this.nodeId + "(" + this.executor + ")";
    }

    @Nonnull
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nonnull
    public String getRuleId() {
        return this.ruleId;
    }

    @Nonnull
    public String getNodeId() {
        return this.nodeId;
    }

    @Nonnull
    public String getModelType() {
        return this.modelType;
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getExecutor() {
        return this.executor;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Map<String, Object> getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Event> getEventOutputs() {
        return this.eventOutputs;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public void setInstanceId(@Nonnull String instanceId) {
        if (instanceId == null) {
            throw new NullPointerException("instanceId is marked @NonNull but is null");
        }
        this.instanceId = instanceId;
    }

    public void setRuleId(@Nonnull String ruleId) {
        if (ruleId == null) {
            throw new NullPointerException("ruleId is marked @NonNull but is null");
        }
        this.ruleId = ruleId;
    }

    public void setNodeId(@Nonnull String nodeId) {
        if (nodeId == null) {
            throw new NullPointerException("nodeId is marked @NonNull but is null");
        }
        this.nodeId = nodeId;
    }

    public void setModelType(@Nonnull String modelType) {
        if (modelType == null) {
            throw new NullPointerException("modelType is marked @NonNull but is null");
        }
        this.modelType = modelType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExecutor(@Nonnull String executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.executor = executor;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setRuleConfiguration(Map<String, Object> ruleConfiguration) {
        this.ruleConfiguration = ruleConfiguration;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public void setEventOutputs(List<Event> eventOutputs) {
        this.eventOutputs = eventOutputs;
    }

    public void setOutputs(List<Output> outputs) {
        this.outputs = outputs;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public static class Output
    implements Serializable {
        @Nonnull
        private String output;
        private Condition condition;

        @Nonnull
        public String getOutput() {
            return this.output;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setOutput(@Nonnull String output) {
            if (output == null) {
                throw new NullPointerException("output is marked @NonNull but is null");
            }
            this.output = output;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public Output(@Nonnull String output, Condition condition) {
            if (output == null) {
                throw new NullPointerException("output is marked @NonNull but is null");
            }
            this.output = output;
            this.condition = condition;
        }

        public Output() {
        }
    }

    public static class Event
    implements Serializable {
        @Nonnull
        private String type;
        @Nonnull
        private String source;

        @Nonnull
        public String getType() {
            return this.type;
        }

        @Nonnull
        public String getSource() {
            return this.source;
        }

        public void setType(@Nonnull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
        }

        public void setSource(@Nonnull String source) {
            if (source == null) {
                throw new NullPointerException("source is marked @NonNull but is null");
            }
            this.source = source;
        }

        public Event(@Nonnull String type, @Nonnull String source) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            if (source == null) {
                throw new NullPointerException("source is marked @NonNull but is null");
            }
            this.type = type;
            this.source = source;
        }

        public Event() {
        }
    }
}

