/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.Output;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class EventBusEventOutput
implements Output {
    private static final Logger log = LoggerFactory.getLogger(EventBusEventOutput.class);
    private final String instanceId;
    private final EventBus eventBus;
    private final String event;
    private final String sourceNode;

    @Override
    public Mono<Boolean> write(Publisher<RuleData> dataStream) {
        return this.eventBus.publish(this.createTopic(this.sourceNode), dataStream).thenReturn((Object)true);
    }

    @Override
    public Mono<Void> write(String nodeId, Publisher<RuleData> data) {
        return this.eventBus.publish(this.createTopic(nodeId), data).then();
    }

    private String createTopic(String node) {
        return RuleConstants.Topics.input(this.instanceId, node);
    }

    public EventBusEventOutput(String instanceId, EventBus eventBus, String event, String sourceNode) {
        this.instanceId = instanceId;
        this.eventBus = eventBus;
        this.event = event;
        this.sourceNode = sourceNode;
    }

    public String getEvent() {
        return this.event;
    }
}

