/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import java.util.Arrays;
import java.util.Optional;
import org.jetlinks.rule.engine.api.RuleData;
import reactor.core.publisher.Flux;

public interface RuleDataCodec<T> {
    public Object encode(T var1, Feature ... var2);

    public Flux<? extends T> decode(RuleData var1, Feature ... var2);

    public static interface Feature {
        default public String getId() {
            return this.getClass().getSimpleName();
        }

        default public String getName() {
            return this.getId();
        }

        default public boolean has(Feature ... features) {
            return Arrays.stream(features).anyMatch(feature -> feature.getId().equals(this.getId()));
        }

        public static <T extends Feature> Optional<T> find(Class<T> type, Feature ... features) {
            return Arrays.stream(features).filter(type::isInstance).map(type::cast).findFirst();
        }
    }
}

