/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;

public class ScheduleJobCompiler {
    private final Map<String, ScheduleJob> jobs = new HashMap<String, ScheduleJob>();
    private final String instanceId;
    private final RuleModel model;

    public ScheduleJobCompiler(String instanceId, RuleModel model) {
        this.instanceId = instanceId;
        this.model = model;
    }

    public List<ScheduleJob> compile() {
        for (RuleNodeModel node : this.model.getNodes()) {
            ScheduleJob job = new ScheduleJob();
            job.setInstanceId(this.instanceId);
            job.setRuleId(this.model.getId());
            job.setNodeId(node.getId());
            job.setConfiguration(node.getConfiguration());
            job.setRuleConfiguration(this.model.getConfiguration());
            job.setModelType(this.model.getType());
            job.setExecutor(node.getExecutor());
            job.setName(node.getName());
            job.setSchedulingRule(node.getSchedulingRule());
            this.jobs.put(node.getId(), job);
        }
        for (RuleNodeModel node : this.model.getNodes()) {
            this.prepare(node);
        }
        return new ArrayList<ScheduleJob>(this.jobs.values());
    }

    private ScheduleJob getJob(String nodeId) {
        return this.jobs.get(nodeId);
    }

    private void prepare(RuleNodeModel node) {
        ScheduleJob job = this.getJob(node.getId());
        ArrayList<String> inputs = new ArrayList<String>();
        for (RuleLink input : node.getInputs()) {
            inputs.add(input.getSource().getId());
        }
        job.setInputs(inputs);
        for (RuleLink event : node.getEvents()) {
            this.getJob(event.getTarget().getId()).getEvents().add(new ScheduleJob.Event(event.getType(), node.getId()));
            job.getEventOutputs().add(new ScheduleJob.Event(event.getType(), event.getTarget().getId()));
        }
        ArrayList<ScheduleJob.Output> outputs = new ArrayList<ScheduleJob.Output>();
        for (RuleLink output : node.getOutputs()) {
            outputs.add(new ScheduleJob.Output(output.getTarget().getId(), output.getCondition()));
        }
        job.setOutputs(outputs);
    }
}

