/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.rule.engine.api.RuleDataCodec;
import org.jetlinks.rule.engine.api.RuleDataCodecSupplier;

public class RuleDataCodecs {
    private static final List<RuleDataCodecSupplier> suppliers = new CopyOnWriteArrayList<RuleDataCodecSupplier>();
    private static final Map<Class, RuleDataCodec<?>> codecs = new ConcurrentHashMap();

    public static void register(RuleDataCodecSupplier supplier) {
        suppliers.add(supplier);
        suppliers.sort(Comparator.comparing(RuleDataCodecSupplier::getOrder));
    }

    public static <T> void register(Class<T> type, RuleDataCodec<T> codec) {
        codecs.put(type, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Optional<RuleDataCodec<T>> getCodec(Class type) {
        RuleDataCodec codec = codecs.get(type);
        if (null != codec) {
            return Optional.of(codec);
        }
        Class clazz = type;
        synchronized (clazz) {
            for (RuleDataCodecSupplier supplier : suppliers) {
                if (!supplier.isSupport(type)) continue;
                codec = supplier.getCodec();
                codecs.put(type, codec);
                return Optional.of(codec);
            }
        }
        return Optional.empty();
    }
}

