/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.Logger;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.defaults.LogEvent;
import org.reactivestreams.Publisher;
import org.slf4j.helpers.MessageFormatter;
import reactor.core.publisher.Mono;

public class EventLogger
implements Logger {
    private final EventBus eventBus;
    private String instanceId;
    private String nodeId;
    private String workerId;

    @Override
    public void trace(String message, Object ... args) {
        this.publishLog("trace", message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.publishLog("info", message, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.publishLog("debug", message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.publishLog("warn", message, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.publishLog("error", message, args);
    }

    private void publishLog(String level, String message, Object ... args) {
        this.eventBus.publish(RuleConstants.Topics.logger(this.instanceId, this.nodeId, level), (Publisher)Mono.fromSupplier(() -> this.createLog(level, message, args))).subscribe();
    }

    private LogEvent createLog(String level, String message, Object ... args) {
        String exception = Arrays.stream(args).filter(Throwable.class::isInstance).map(Throwable.class::cast).map(StringUtils::throwable2String).collect(Collectors.joining());
        return LogEvent.builder().level(level).message(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage()).instanceId(this.instanceId).nodeId(this.nodeId).workerId(this.workerId).timestamp(System.currentTimeMillis()).exception(exception).build();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public EventLogger(EventBus eventBus, String instanceId, String nodeId, String workerId) {
        this.eventBus = eventBus;
        this.instanceId = instanceId;
        this.nodeId = nodeId;
        this.workerId = workerId;
    }
}

