/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.rule.engine.api.scope.ContextScope;
import org.jetlinks.rule.engine.api.scope.FlowScope;
import org.jetlinks.rule.engine.api.scope.NodeScope;
import org.jetlinks.rule.engine.defaults.scope.InMemoryContextScope;
import org.jetlinks.rule.engine.defaults.scope.InMemoryNodeScope;
import org.jetlinks.rule.engine.defaults.scope.InMemoryPersistenceScope;

public class InMemoryFlowScope
extends InMemoryPersistenceScope
implements FlowScope {
    private final Map<String, NodeScope> nodeScopeMap = new ConcurrentHashMap<String, NodeScope>();
    private final Map<String, ContextScope> contextScopeMap = new ConcurrentHashMap<String, ContextScope>();

    @Override
    public NodeScope node(String id) {
        return this.nodeScopeMap.computeIfAbsent(id, k -> new InMemoryNodeScope());
    }

    @Override
    public ContextScope context(String id) {
        return this.contextScopeMap.computeIfAbsent(id, k -> new InMemoryContextScope());
    }
}

