/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;
import org.springframework.util.StringUtils;

public class RuleNodeModel {
    private String id;
    private String ruleId;
    private String name;
    private String description;
    private String executor;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private SchedulingRule schedulingRule;
    private boolean end;
    private boolean start;
    private List<RuleLink> events = new ArrayList<RuleLink>();
    private List<RuleLink> inputs = new ArrayList<RuleLink>();
    private List<RuleLink> outputs = new ArrayList<RuleLink>();
    @Deprecated
    private boolean parallel;

    public RuleNodeModel addConfiguration(String key, Object value) {
        this.configuration.put(key, SerializeUtils.convertToSafelySerializable((Object)value, (boolean)true));
        return this;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration.clear();
        this.configuration.putAll((Map)SerializeUtils.convertToSafelySerializable(configuration, (boolean)true));
    }

    public List<RuleLink> getEvents(String type) {
        return this.events.stream().filter(link -> type.equals(link.getType())).collect(Collectors.toList());
    }

    public boolean isStartNode() {
        return this.start || this.inputs == null || this.inputs.isEmpty();
    }

    public boolean isEndNode() {
        return this.end || this.outputs == null || this.outputs.isEmpty();
    }

    private void appendMermaidNode(StringBuilder builder) {
        builder.append(this.getId());
        builder.append(this.isStartNode() || this.isEndNode() ? "[" : "(");
        if (StringUtils.hasText((String)this.name)) {
            builder.append(this.name);
        } else {
            builder.append(this.executor);
        }
        builder.append(this.isStartNode() || this.isEndNode() ? "]" : ")");
    }

    public void appendMermaid(StringBuilder builder) {
        if (CollectionUtils.isNotEmpty(this.outputs)) {
            int index = 0;
            for (RuleLink output : this.outputs) {
                if (index++ > 0) {
                    builder.append("\n");
                }
                this.appendMermaidNode(builder);
                builder.append("-->");
                if (StringUtils.hasText((String)output.getDescription())) {
                    builder.append("|").append(output.getDescription()).append("|");
                }
                output.getTarget().appendMermaidNode(builder);
            }
        } else {
            this.appendMermaidNode(builder);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendMermaid(builder);
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutor() {
        return this.executor;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public boolean isEnd() {
        return this.end;
    }

    public boolean isStart() {
        return this.start;
    }

    public List<RuleLink> getEvents() {
        return this.events;
    }

    public List<RuleLink> getInputs() {
        return this.inputs;
    }

    public List<RuleLink> getOutputs() {
        return this.outputs;
    }

    @Deprecated
    public boolean isParallel() {
        return this.parallel;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setEvents(List<RuleLink> events) {
        this.events = events;
    }

    public void setInputs(List<RuleLink> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<RuleLink> outputs) {
        this.outputs = outputs;
    }

    @Deprecated
    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }
}

