/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.utils.SerializeUtils;

public class LogEvent
implements Externalizable {
    private String instanceId;
    private String nodeId;
    private String workerId;
    private String level;
    private String message;
    private String exception;
    private long timestamp;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.instanceId);
        out.writeUTF(this.nodeId);
        out.writeUTF(this.workerId);
        out.writeUTF(this.level);
        SerializeUtils.writeObject((Object)this.message, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.exception, (ObjectOutput)out);
        out.writeLong(this.timestamp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.instanceId = in.readUTF();
        this.nodeId = in.readUTF();
        this.workerId = in.readUTF();
        this.level = in.readUTF();
        this.message = (String)SerializeUtils.readObject((ObjectInput)in);
        this.exception = (String)SerializeUtils.readObject((ObjectInput)in);
        this.timestamp = in.readLong();
    }

    public static LogEventBuilder builder() {
        return new LogEventBuilder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public LogEvent(String instanceId, String nodeId, String workerId, String level, String message, String exception, long timestamp) {
        this.instanceId = instanceId;
        this.nodeId = nodeId;
        this.workerId = workerId;
        this.level = level;
        this.message = message;
        this.exception = exception;
        this.timestamp = timestamp;
    }

    public LogEvent() {
    }

    public static class LogEventBuilder {
        private String instanceId;
        private String nodeId;
        private String workerId;
        private String level;
        private String message;
        private String exception;
        private long timestamp;

        LogEventBuilder() {
        }

        public LogEventBuilder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public LogEventBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public LogEventBuilder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public LogEventBuilder level(String level) {
            this.level = level;
            return this;
        }

        public LogEventBuilder message(String message) {
            this.message = message;
            return this;
        }

        public LogEventBuilder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public LogEventBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public LogEvent build() {
            return new LogEvent(this.instanceId, this.nodeId, this.workerId, this.level, this.message, this.exception, this.timestamp);
        }

        public String toString() {
            return "LogEvent.LogEventBuilder(instanceId=" + this.instanceId + ", nodeId=" + this.nodeId + ", workerId=" + this.workerId + ", level=" + this.level + ", message=" + this.message + ", exception=" + this.exception + ", timestamp=" + this.timestamp + ")";
        }
    }
}

