/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import io.opentelemetry.api.common.AttributeKey;
import java.util.function.BiConsumer;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.ReactiveSpanBuilder;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;

public interface RuleConstants {

    public static interface Tags {
        public static final String contextId = "_contextId";
    }

    public static interface Trace {
        public static final AttributeKey<String> instanceId = AttributeKey.stringKey((String)"instanceId");
        public static final AttributeKey<String> name = AttributeKey.stringKey((String)"name");
        public static final AttributeKey<String> nodeId = AttributeKey.stringKey((String)"nodeId");
        public static final AttributeKey<String> executor = AttributeKey.stringKey((String)"executor");
        public static final AttributeKey<String> configuration = AttributeKey.stringKey((String)"configuration");
        public static final AttributeKey<String> model = AttributeKey.stringKey((String)"model");

        public static String spanName(String instanceId, String operation) {
            return String.join((CharSequence)"/", "/rule-engine", instanceId, operation);
        }

        public static String nodeSpanName(String instanceId, String nodeId, String operation) {
            return String.join((CharSequence)"/", "/rule-engine", instanceId, nodeId, operation);
        }

        public static String reloadNodeSpanName(String instanceId, String nodeId) {
            return Trace.nodeSpanName(instanceId, nodeId, "reload");
        }

        public static String startNodeSpanName(String instanceId, String nodeId) {
            return Trace.nodeSpanName(instanceId, nodeId, "start");
        }

        public static String shutdownNodeSpanName(String instanceId, String nodeId) {
            return Trace.nodeSpanName(instanceId, nodeId, "shutdown");
        }

        public static <T> MonoTracer<T> traceMono(ScheduleJob job, String operation) {
            return Trace.traceMono(job, operation, (job1, builder) -> {});
        }

        public static <T> MonoTracer<T> traceMono(ScheduleJob job, String operation, BiConsumer<ScheduleJob, ReactiveSpanBuilder> biConsumer) {
            return MonoTracer.create((String)Trace.nodeSpanName(job.getInstanceId(), job.getNodeId(), operation), builder -> {
                builder.setAttribute(instanceId, (Object)job.getInstanceId());
                builder.setAttribute(nodeId, (Object)job.getNodeId());
                builder.setAttribute(name, (Object)job.getName());
                biConsumer.accept(job, (ReactiveSpanBuilder)builder);
            });
        }

        public static <T> FluxTracer<T> traceFlux(ScheduleJob job, String operation) {
            return Trace.traceFlux(job, operation, (job1, builder) -> {});
        }

        public static <T> FluxTracer<T> traceFlux(ScheduleJob job, String operation, BiConsumer<ScheduleJob, ReactiveSpanBuilder> biConsumer) {
            return FluxTracer.create((String)Trace.nodeSpanName(job.getInstanceId(), job.getNodeId(), operation), builder -> {
                builder.setAttribute(instanceId, (Object)job.getInstanceId());
                builder.setAttribute(nodeId, (Object)job.getNodeId());
                builder.setAttribute(name, (Object)job.getName());
                biConsumer.accept(job, (ReactiveSpanBuilder)builder);
            });
        }
    }

    public static interface Topics {
        public static final SharedPathString templatePrefix = SharedPathString.of((String)"/rule-engine/*/*");
        public static final SharedPathString allEvent = SharedPathString.of((String)"/rule-engine/*/*/event/*");
        public static final SharedPathString allLogger = SharedPathString.of((String)"/rule-engine/*/*/logger/*");
        public static final String allAction = "/rule-engine/*/*/action/**";
        public static final SharedPathString actionPrefix = SharedPathString.of((String)"/rule-engine/*/*/action");

        public static SeparatedCharSequence prefix0(String instanceId, String nodeId) {
            return templatePrefix.replace(2, (CharSequence)instanceId, 3, (CharSequence)nodeId);
        }

        public static String prefix(String instanceId, String nodeId) {
            return "/rule-engine/" + instanceId + "/" + nodeId;
        }

        public static String input(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/input";
        }

        public static String shutdown(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/shutdown";
        }

        public static CharSequence event0(String instanceId, String nodeId, String event) {
            return allEvent.replace(2, (CharSequence)instanceId, 3, (CharSequence)nodeId, 5, (CharSequence)event);
        }

        public static String event(String instanceId, String nodeId, String event) {
            return Topics.prefix(instanceId, nodeId) + "/event/" + event;
        }

        public static String logger(String instanceId, String nodeId, String level) {
            return Topics.prefix(instanceId, nodeId) + "/logger/" + level;
        }

        public static CharSequence logger0(String instanceId, String nodeId, String level) {
            return allLogger.replace(2, (CharSequence)instanceId, 3, (CharSequence)nodeId, 5, (CharSequence)level);
        }

        public static CharSequence action(String instanceId, String nodeId, CharSequence action) {
            return actionPrefix.replace(2, (CharSequence)instanceId, 3, (CharSequence)nodeId).append(action);
        }

        public static String state(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/state";
        }

        public static SeparatedCharSequence state0(String instanceId, String nodeId) {
            return Topics.prefix0(instanceId, nodeId).append((CharSequence)"state");
        }
    }

    public static interface Event {
        public static final String error = "error";
        public static final String result = "result";
        public static final String complete = "complete";
        public static final String start = "start";
        public static final String paused = "paused";
    }

    public static interface Headers {
        public static final String ruleConfiguration = "ruleConf";
        public static final String jobExecutor = "jobExecutor";
        public static final String modelType = "modelType";
    }

    public static interface ConfigKey {
        public static final String enableRecorder = "enableRecorder";
    }
}

