/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.Routable;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.rule.engine.api.RuleDataHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RuleData
extends GenericHeaderSupport<RuleData>
implements Externalizable,
Routable {
    private static final long serialVersionUID = 1L;
    public static final String RECORD_DATA_TO_HEADER = "record_data_to_header";
    public static final String RECORD_DATA_TO_HEADER_KEY = "record_data_to_header_key";
    public static final String RECORD_DATA_TO_HEADER_KEY_PREFIX = "rd:";
    public static final String HEADER_SOURCE_NODE_ID = "sourceNode";
    private String id;
    private String contextId;
    private Object data;

    public void setHeader(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.addHeader(key, value);
    }

    public Flux<Map<String, Object>> dataToMap() {
        Object data = this.data;
        if (data instanceof Map) {
            return Flux.just((Object)((Map)data));
        }
        if (data instanceof Jsonable) {
            return Flux.just((Object)((Jsonable)data).toJson());
        }
        if (data instanceof RuleData) {
            return ((RuleData)data).dataToMap();
        }
        return Flux.create((T sink) -> {
            this.acceptMap(arg_0 -> ((FluxSink)sink).next(arg_0));
            sink.complete();
        });
    }

    public void acceptMap(Consumer<Map<String, Object>> consumer) {
        String stringData;
        Object data = this.data;
        if (data == null) {
            return;
        }
        if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            if (bytes.length > 2 && (bytes[0] == 123 && bytes[bytes.length - 1] == 125 || bytes[0] == 91 && bytes[bytes.length - 1] == 93)) {
                data = JSON.parse((byte[])bytes, (Feature[])new Feature[0]);
            }
        } else if (data instanceof String && ((stringData = (String)data).startsWith("{") || stringData.startsWith("["))) {
            data = JSON.parse((String)stringData);
        }
        if (data instanceof Map) {
            consumer.accept((Map)data);
        } else if (data instanceof Jsonable) {
            consumer.accept((Map<String, Object>)((Jsonable)data).toJson());
        } else if (data instanceof RuleData) {
            ((RuleData)data).acceptMap(consumer);
        } else if (data instanceof Iterable) {
            for (Object datum : (Iterable)data) {
                this.doAcceptMap(datum, consumer);
            }
        } else {
            this.doAcceptMap(data, consumer);
        }
    }

    private void doAcceptMap(Object data, Consumer<Map<String, Object>> consumer) {
        if (data == null) {
            return;
        }
        if (data instanceof Map) {
            consumer.accept((Map)data);
        } else if (data instanceof Jsonable) {
            consumer.accept((Map<String, Object>)((Jsonable)data).toJson());
        } else {
            consumer.accept((Map)FastBeanCopier.copy((Object)data, HashMap::new, (String[])new String[0]));
        }
    }

    public RuleData newData(Object data) {
        RuleData ruleData = new RuleData();
        if (data instanceof RuleData) {
            data = ((RuleData)data).getData();
        }
        ruleData.id = (String)IDGenerator.RANDOM.generate();
        if (this.getHeaders() != null) {
            this.getHeaders().forEach((arg_0, arg_1) -> ((RuleData)ruleData).addHeader(arg_0, arg_1));
        }
        ruleData.data = data;
        ruleData.contextId = this.contextId;
        RuleDataHelper.clearError(ruleData);
        return ruleData;
    }

    public RuleData copy() {
        RuleData ruleData = new RuleData();
        ruleData.id = this.id;
        ruleData.contextId = this.contextId;
        if (this.getHeaders() != null) {
            this.getHeaders().forEach((arg_0, arg_1) -> ((RuleData)ruleData).addHeader(arg_0, arg_1));
        }
        ruleData.data = this.data;
        return ruleData;
    }

    public static RuleData create(Object data) {
        if (data instanceof RuleData) {
            return ((RuleData)data).newData(data);
        }
        RuleData ruleData = new RuleData();
        ruleData.setId((String)IDGenerator.RANDOM.generate());
        ruleData.setContextId((String)IDGenerator.RANDOM.generate());
        ruleData.setData(data);
        return ruleData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject((Object)this.id, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.contextId, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.data, (ObjectOutput)out);
        SerializeUtils.writeKeyValue((Map)this.getHeaders(), (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)SerializeUtils.readObject((ObjectInput)in);
        this.contextId = (String)SerializeUtils.readObject((ObjectInput)in);
        this.data = SerializeUtils.readObject((ObjectInput)in);
        SerializeUtils.readKeyValue((ObjectInput)in, (arg_0, arg_1) -> ((RuleData)this).addHeader(arg_0, arg_1));
    }

    public Object routeKey() {
        return this.getHeader(Headers.routeKey).orElseGet(() -> this.data instanceof Routable ? ((Routable)this.data).routeKey() : this.contextId);
    }

    public long hash(Object ... objects) {
        if (this.data instanceof Routable) {
            return ((Routable)this.data).hash(objects);
        }
        return super.hash(objects);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getContextId() {
        return this.contextId;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Generated
    public void setData(Object data) {
        this.data = data;
    }

    static {
        SerializeUtils.registerSerializer((int)80, RuleData.class, ignore -> new RuleData());
    }
}

