/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import java.util.Objects;
import lombok.Generated;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.rule.engine.api.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Slf4jLogger
implements Logger {
    @Generated
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Slf4jLogger.class);
    private final CharSequence name;

    public Slf4jLogger(CharSequence name) {
        this.name = name;
    }

    public static boolean isEnabled() {
        return log.isErrorEnabled();
    }

    public boolean isEnabled(Level level) {
        return log.isEnabledForLevel(level);
    }

    @Override
    public void trace(String text, Object ... args) {
        log.trace(text, args);
    }

    @Override
    public void info(String message, Object ... args) {
        if (log.isInfoEnabled()) {
            String msg = LocaleUtils.resolveMessage((String)message, (String)message, (Object[])args);
            if (Objects.equals(msg, message)) {
                log.info(this.name + ":" + message, args);
            } else {
                log.info("{}:{}", (Object)this.name, (Object)message);
            }
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.name + ":" + message, args);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (log.isWarnEnabled()) {
            String msg = LocaleUtils.resolveMessage((String)message, (String)message, (Object[])args);
            if (Objects.equals(msg, message)) {
                log.warn(this.name + ":" + message, args);
            } else {
                log.warn("{}:{}", (Object)this.name, (Object)message);
            }
        }
    }

    @Override
    public void error(String message, Object ... args) {
        log.error(this.name + ":" + message, args);
    }
}

