/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;

public class RuleModel {
    private String id;
    private String name;
    private String type;
    private String description;
    private SchedulingRule schedulingRule;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private List<RuleLink> events = new ArrayList<RuleLink>();
    private List<RuleNodeModel> nodes = new ArrayList<RuleNodeModel>();

    public RuleLink link(RuleNodeModel source, RuleNodeModel target) {
        RuleLink link = new RuleLink();
        link.setId(source.getId() + ":" + target.getId());
        link.setName(source.getName() + ":" + target.getName());
        link.setSource(source);
        link.setTarget(target);
        source.getOutputs().add(link);
        target.getInputs().add(link);
        return link;
    }

    public List<RuleLink> getEvents(String type) {
        return this.events.stream().filter(link -> type.equals(link.getType())).collect(Collectors.toList());
    }

    public Optional<RuleNodeModel> getNode(String nodeId) {
        return this.nodes.stream().filter(model -> model.getId().equals(nodeId)).findFirst();
    }

    public RuleModel addConfiguration(String key, Object value) {
        this.configuration.put(key, SerializeUtils.convertToSafelySerializable((Object)value, (boolean)true));
        return this;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration.clear();
        this.configuration.putAll((Map)SerializeUtils.convertToSafelySerializable(configuration, (boolean)true));
    }

    public Optional<RuleNodeModel> getStartNode() {
        return this.nodes.stream().filter(RuleNodeModel::isStart).findFirst();
    }

    public List<RuleNodeModel> getStartNodes() {
        return this.nodes.stream().filter(RuleNodeModel::isStartNode).collect(Collectors.toList());
    }

    public List<RuleNodeModel> getEndNodes() {
        return this.nodes.stream().filter(RuleNodeModel::isEnd).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (RuleNodeModel node : this.getNodes()) {
            if (index++ > 0) {
                stringBuilder.append("\n");
            }
            node.appendMermaid(stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    @Generated
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<RuleLink> getEvents() {
        return this.events;
    }

    @Generated
    public List<RuleNodeModel> getNodes() {
        return this.nodes;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    @Generated
    public void setEvents(List<RuleLink> events) {
        this.events = events;
    }

    @Generated
    public void setNodes(List<RuleNodeModel> nodes) {
        this.nodes = nodes;
    }
}

