/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.rule.engine.api.model.Condition;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;

public class ScheduleJob
implements Serializable {
    private static final long serialVersionUID = -1L;
    @Nonnull
    private String instanceId;
    @Nonnull
    private String ruleId;
    @Nonnull
    private String nodeId;
    private String modelType;
    private String name;
    @Nonnull
    private String executor;
    private Map<String, Object> configuration;
    private Map<String, Object> ruleConfiguration;
    private List<String> inputs = new ArrayList<String>();
    private List<Event> events = new ArrayList<Event>();
    private List<Event> eventOutputs = new ArrayList<Event>();
    private List<Output> outputs = new ArrayList<Output>();
    private Map<String, Object> context = new HashMap<String, Object>();
    private SchedulingRule schedulingRule;

    public Optional<Object> getRuleConfiguration(String key) {
        if (MapUtils.isEmpty(this.ruleConfiguration)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.ruleConfiguration.get(key));
    }

    public Optional<Object> getConfiguration(String key) {
        if (MapUtils.isEmpty(this.configuration)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.configuration.get(key));
    }

    public String toString() {
        return this.instanceId + ":" + this.nodeId + "(" + this.executor + ")";
    }

    @Nonnull
    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nonnull
    @Generated
    public String getRuleId() {
        return this.ruleId;
    }

    @Nonnull
    @Generated
    public String getNodeId() {
        return this.nodeId;
    }

    @Generated
    public String getModelType() {
        return this.modelType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nonnull
    @Generated
    public String getExecutor() {
        return this.executor;
    }

    @Generated
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, Object> getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<Event> getEvents() {
        return this.events;
    }

    @Generated
    public List<Event> getEventOutputs() {
        return this.eventOutputs;
    }

    @Generated
    public List<Output> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Generated
    public SchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    @Generated
    public void setInstanceId(@Nonnull String instanceId) {
        if (instanceId == null) {
            throw new NullPointerException("instanceId is marked non-null but is null");
        }
        this.instanceId = instanceId;
    }

    @Generated
    public void setRuleId(@Nonnull String ruleId) {
        if (ruleId == null) {
            throw new NullPointerException("ruleId is marked non-null but is null");
        }
        this.ruleId = ruleId;
    }

    @Generated
    public void setNodeId(@Nonnull String nodeId) {
        if (nodeId == null) {
            throw new NullPointerException("nodeId is marked non-null but is null");
        }
        this.nodeId = nodeId;
    }

    @Generated
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setExecutor(@Nonnull String executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
    }

    @Generated
    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setRuleConfiguration(Map<String, Object> ruleConfiguration) {
        this.ruleConfiguration = ruleConfiguration;
    }

    @Generated
    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    @Generated
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    @Generated
    public void setEventOutputs(List<Event> eventOutputs) {
        this.eventOutputs = eventOutputs;
    }

    @Generated
    public void setOutputs(List<Output> outputs) {
        this.outputs = outputs;
    }

    @Generated
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Generated
    public void setSchedulingRule(SchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public static class Output
    implements Serializable {
        @Nonnull
        private String output;
        private Condition condition;

        @Nonnull
        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public Condition getCondition() {
            return this.condition;
        }

        @Generated
        public void setOutput(@Nonnull String output) {
            if (output == null) {
                throw new NullPointerException("output is marked non-null but is null");
            }
            this.output = output;
        }

        @Generated
        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        @Generated
        public Output(@Nonnull String output, Condition condition) {
            if (output == null) {
                throw new NullPointerException("output is marked non-null but is null");
            }
            this.output = output;
            this.condition = condition;
        }

        @Generated
        public Output() {
        }
    }

    public static class Event
    implements Serializable {
        @Nonnull
        private String type;
        @Nonnull
        private String source;

        @Nonnull
        @Generated
        public String getType() {
            return this.type;
        }

        @Nonnull
        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public void setType(@Nonnull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @Generated
        public void setSource(@Nonnull String source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
        }

        @Generated
        public Event(@Nonnull String type, @Nonnull String source) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.type = type;
            this.source = source;
        }

        @Generated
        public Event() {
        }
    }
}

