/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.task;

import java.util.List;
import lombok.Generated;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.Output;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeOutput
implements Output {
    private final List<Output> outputs;

    @Override
    public Mono<Boolean> write(RuleData data) {
        if (this.outputs.size() == 1) {
            return this.outputs.get(0).write(data);
        }
        return Flux.fromIterable(this.outputs).flatMap(out -> out.write(data)).reduce(Boolean::logicalAnd);
    }

    @Override
    public Mono<Boolean> write(Publisher<RuleData> dataStream) {
        return Flux.from(dataStream).flatMap(data -> Flux.fromIterable(this.outputs).flatMap(out -> out.write((RuleData)data))).reduce(Boolean::logicalAnd);
    }

    @Override
    public Mono<Void> write(String nodeId, RuleData data) {
        if (this.outputs.size() == 1) {
            return this.outputs.get(0).write(nodeId, data);
        }
        return Flux.fromIterable(this.outputs).flatMap(out -> out.write(nodeId, data)).then();
    }

    @Override
    public Mono<Void> write(String nodeId, Publisher<RuleData> dataStream) {
        return Flux.from(dataStream).flatMap(data -> Flux.fromIterable(this.outputs).flatMap(out -> out.write(nodeId, (Publisher<RuleData>)Mono.just((Object)data)))).then();
    }

    @Generated
    private CompositeOutput(List<Output> outputs) {
        this.outputs = outputs;
    }

    @Generated
    public static CompositeOutput of(List<Output> outputs) {
        return new CompositeOutput(outputs);
    }
}

