/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import io.opentelemetry.api.common.AttributeKey;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.utils.RecursiveUtils;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutableTaskExecutor;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public abstract class AbstractTaskExecutor
implements ExecutableTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskExecutor.class);
    protected static final AttributeKey<String> executor_name = AttributeKey.stringKey((String)"name");
    protected static final int DEFAULT_MAX_RECURSIVE = Integer.getInteger("rule.engine.max_recursive", 0);
    protected ExecutionContext context;
    protected volatile Task.State state = Task.State.shutdown;
    protected volatile Disposable disposable;
    private BiConsumer<Task.State, Task.State> stateListener = (from, to) -> log.debug("task [{}] state changed from {} to {}.", new Object[]{this.context.getJob(), from, to});

    public AbstractTaskExecutor(ExecutionContext context) {
        this.context = context;
    }

    protected <T> MonoTracer<T> tracer() {
        return this.context.monitor().tracer().traceMono("execute");
    }

    protected <T> FluxTracer<T> traceFlux() {
        return this.context.monitor().tracer().traceFlux("execute");
    }

    @Override
    public abstract String getName();

    protected abstract Disposable doStart();

    protected void changeState(Task.State state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.stateListener.accept(this.state, this.state);
    }

    @Override
    public synchronized void start() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.changeState(Task.State.running);
            return;
        }
        this.disposable = this.doStart();
        this.changeState(Task.State.running);
    }

    @Override
    public void reload() {
    }

    @Override
    public void pause() {
        this.changeState(Task.State.paused);
    }

    @Override
    public synchronized void shutdown() {
        this.changeState(Task.State.shutdown);
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    @Override
    public void onStateChanged(BiConsumer<Task.State, Task.State> listener) {
        this.stateListener = this.stateListener.andThen(listener);
    }

    @Override
    public void validate() {
    }

    @Override
    public Mono<Void> execute(RuleData ruleData) {
        return ((Mono)this.context.getOutput().write(this.context.newRuleData(ruleData)).as(this.tracer())).then();
    }

    protected Function<Context, Context> contextWriter() {
        if (this.maxRecursive() >= 0) {
            return RecursiveUtils.validator((String)("rule:" + this.context.getInstanceId() + ":" + this.context.getJob().getNodeId()), (int)this.maxRecursive());
        }
        return Function.identity();
    }

    protected int maxRecursive() {
        return DEFAULT_MAX_RECURSIVE;
    }

    @Generated
    public ExecutionContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Task.State getState() {
        return this.state;
    }
}

