/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.function.Function;
import lombok.Generated;
import org.jetlinks.rule.engine.api.RuleEngine;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.scheduler.Scheduler;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.defaults.ScheduleJobCompiler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultRuleEngine
implements RuleEngine {
    private final Scheduler scheduler;

    @Override
    public Flux<Task> startRule(String instanceId, RuleModel model) {
        return Flux.fromIterable(new ScheduleJobCompiler(instanceId, model).compile()).flatMap(this.scheduler::schedule).collectList().flatMapIterable(Function.identity()).flatMap(task -> task.start().thenReturn(task));
    }

    @Override
    public Flux<Task> getTasks(String instanceId) {
        return this.scheduler.getSchedulingTask(instanceId);
    }

    @Override
    public Mono<Void> shutdown(String instanceId) {
        return this.scheduler.shutdown(instanceId);
    }

    @Override
    public Flux<Worker> getWorkers() {
        return this.scheduler.getWorkers();
    }

    @Generated
    public DefaultRuleEngine(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

