/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import java.util.Objects;
import lombok.Generated;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedString;
import org.jetlinks.core.utils.ExceptionUtils;
import org.jetlinks.rule.engine.api.Logger;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.defaults.LogEvent;
import org.reactivestreams.Publisher;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class EventLogger
implements Logger {
    public static final SeparatedCharSequence LOG_TEMPLATE = SeparatedString.create((char)'.', (String[])new String[]{"rule", "engine", "*", "*"});
    private final EventBus eventBus;
    private String instanceId;
    private String nodeId;
    private String workerId;

    public String getName() {
        return LOG_TEMPLATE.replace(2, (CharSequence)this.instanceId, 3, (CharSequence)this.nodeId).toString();
    }

    @Override
    public void trace(String message, Object ... args) {
        this.publishLog("trace", message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.publishLog("info", message, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.publishLog("debug", message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.publishLog("warn", message, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.publishLog("error", message, args);
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        this.publishLog(level.name().toLowerCase(), message, args);
    }

    private void publishLog(String level, String message, Object ... args) {
        this.eventBus.publish(RuleConstants.Topics.logger0(this.instanceId, this.nodeId, level), (Publisher)Mono.deferContextual(ctx -> Mono.just((Object)this.createLog((ContextView)ctx, level, message, args)))).subscribe();
    }

    private LogEvent createLog(ContextView ctx, String level, String message, Object ... args) {
        String i18nMaybe;
        Throwable error = MessageFormatter.getThrowableCandidate((Object[])args);
        if (null != error) {
            args = MessageFormatter.trimmedCopy((Object[])args);
        }
        String msg = !Objects.equals(message, i18nMaybe = LocaleUtils.resolveMessage((String)message, (Object[])args)) ? i18nMaybe : MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        String exception = ExceptionUtils.getStackTrace((Throwable)error);
        LogEvent event = LogEvent.builder().level(level).message(msg).instanceId(this.instanceId).nodeId(this.nodeId).workerId(this.workerId).timestamp(System.currentTimeMillis()).exception(exception).build();
        Context traceContext = ctx.getOrEmpty(Context.class).orElseGet(Context::current);
        SpanContext spanContext = Span.fromContext((Context)traceContext).getSpanContext();
        if (spanContext.isValid()) {
            event.setTraceId(spanContext.getTraceId());
            event.setSpanId(spanContext.getSpanId());
        }
        return event;
    }

    @Generated
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getNodeId() {
        return this.nodeId;
    }

    @Generated
    public String getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Generated
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @Generated
    public EventLogger(EventBus eventBus, String instanceId, String nodeId, String workerId) {
        this.eventBus = eventBus;
        this.instanceId = instanceId;
        this.nodeId = nodeId;
        this.workerId = workerId;
    }
}

