/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scheduler;

import java.util.concurrent.TimeoutException;
import org.jetlinks.core.rpc.DisposableService;
import org.jetlinks.core.rpc.RpcServiceFactory;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scheduler.Scheduler;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.cluster.scheduler.SchedulerRpcService;
import org.jetlinks.rule.engine.cluster.task.RemoteTask;
import org.jetlinks.rule.engine.cluster.worker.RemoteWorker;
import reactor.bool.BooleanUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RemoteScheduler
implements Scheduler,
Disposable {
    private final String id;
    private SchedulerRpcService rpcService;
    private final RpcServiceFactory factory;
    private Disposable disposable;

    public RemoteScheduler(String id, RpcServiceFactory factory) {
        this.id = id;
        this.factory = factory;
    }

    public void init() {
        DisposableService service = this.factory.createProducer("/rule-engine/cluster-scheduler:" + this.id, SchedulerRpcService.class);
        this.disposable = service;
        this.rpcService = (SchedulerRpcService)service.getService();
    }

    public Mono<Boolean> isAlive() {
        return this.rpcService.isAlive().onErrorResume(TimeoutException.class, r -> Mono.just((Object)false));
    }

    public Mono<Boolean> isNoAlive() {
        return BooleanUtils.not(this.isAlive());
    }

    public Flux<Worker> getWorkers() {
        return this.rpcService.getWorkers().map(info -> new RemoteWorker(info.getId(), info.getName(), this.rpcService));
    }

    public Mono<Worker> getWorker(String workerId) {
        return this.rpcService.getWorker(workerId).map(info -> new RemoteWorker(info.getId(), info.getName(), this.rpcService));
    }

    public Flux<Task> schedule(ScheduleJob job) {
        return this.rpcService.schedule(job).map(taskInfo -> new RemoteTask(taskInfo.getId(), taskInfo.getName(), taskInfo.getWorkerId(), this.id, this.rpcService, job));
    }

    public Mono<Void> shutdown(String instanceId) {
        return this.rpcService.shutdown(instanceId);
    }

    public Flux<Task> getSchedulingTask(String instanceId) {
        return this.rpcService.getSchedulingTask(instanceId).map(taskInfo -> new RemoteTask(taskInfo.getId(), taskInfo.getName(), taskInfo.getWorkerId(), this.id, this.rpcService, taskInfo.getJob()));
    }

    public Flux<Task> getSchedulingTasks() {
        return this.rpcService.getSchedulingTasks().map(taskInfo -> new RemoteTask(taskInfo.getId(), taskInfo.getName(), taskInfo.getWorkerId(), this.id, this.rpcService, taskInfo.getJob()));
    }

    public Mono<Long> totalTask() {
        return this.rpcService.totalTask().defaultIfEmpty((Object)0L);
    }

    public Mono<Boolean> canSchedule(ScheduleJob job) {
        return this.rpcService.canSchedule(job);
    }

    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposable == null || this.disposable.isDisposed();
    }

    public RemoteScheduler(String id, SchedulerRpcService rpcService, RpcServiceFactory factory, Disposable disposable) {
        this.id = id;
        this.rpcService = rpcService;
        this.factory = factory;
        this.disposable = disposable;
    }

    public String getId() {
        return this.id;
    }
}

