/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scheduler;

import java.util.List;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import org.jetlinks.rule.engine.api.worker.Worker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface SchedulerRpcService {
    public Flux<WorkerInfo> getWorkers();

    public Mono<WorkerInfo> getWorker(String var1);

    public Flux<TaskInfo> schedule(ScheduleJob var1);

    public Mono<Void> shutdown(String var1);

    public Flux<TaskInfo> getSchedulingTask(String var1);

    public Flux<TaskInfo> getSchedulingTasks();

    public Mono<Long> totalTask();

    public Mono<Boolean> canSchedule(ScheduleJob var1);

    public Mono<Void> executeTask(String var1, RuleData var2);

    public Mono<Task.State> getTaskState(String var1);

    public Mono<Void> taskOperation(String var1, TaskOperation var2);

    public Mono<Void> setTaskJob(String var1, ScheduleJob var2);

    public Mono<Long> getLastStateTime(String var1);

    public Mono<Long> getStartTime(String var1);

    public Mono<TaskInfo> createTask(String var1, ScheduleJob var2);

    public Mono<List<String>> getSupportExecutors(String var1);

    public Mono<Worker.State> getWorkerState(String var1);

    public Mono<Boolean> isAlive();

    public Mono<TaskSnapshot> dumpTask(String var1);

    public static enum TaskOperation {
        START,
        PAUSE,
        RELOAD,
        SHUTDOWN,
        ENABLE_DEBUG,
        DISABLE_DEBUG;

    }

    public static class TaskInfo {
        private String id;
        private String name;
        private String workerId;
        private ScheduleJob job;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getWorkerId() {
            return this.workerId;
        }

        public ScheduleJob getJob() {
            return this.job;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        public TaskInfo(String id, String name, String workerId, ScheduleJob job) {
            this.id = id;
            this.name = name;
            this.workerId = workerId;
            this.job = job;
        }

        public TaskInfo() {
        }
    }

    public static class WorkerInfo {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public WorkerInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public WorkerInfo() {
        }
    }
}

