/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster;

public interface ClusterConstants {

    public static interface Topics {
        public static String workerPrefix(String workerId) {
            return "/rule-engine/cluster-worker/" + workerId;
        }

        public static String schedulerPrefix(String scheduler) {
            return "/rule-engine/cluster-scheduler/" + scheduler;
        }

        public static String createTask(String workerId) {
            return Topics.workerPrefix(workerId) + "/create_task";
        }

        public static String getWorkerSupportExecutors(String workerId) {
            return Topics.workerPrefix(workerId) + "/executor/supports";
        }

        public static String getWorkerState(String workerId) {
            return Topics.workerPrefix(workerId) + "/state";
        }

        public static String setTaskJob(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/set_job";
        }

        public static String getLastStateTime(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/last_state_time";
        }

        public static String getStartTime(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/last_start_time";
        }

        public static String taskOperation(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/operation";
        }

        public static String taskExecute(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/execute";
        }

        public static String getTaskState(String workerId, String taskId) {
            return Topics.workerPrefix(workerId) + "/task/" + taskId + "/state";
        }

        public static String getSchedulerWorkers(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/workers";
        }

        public static String scheduleJob(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/schedule";
        }

        public static String shutdown(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/shutdown";
        }

        public static String totalScheduling(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/scheduling-total";
        }

        public static String getScheduleJobs(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/scheduling";
        }

        public static String getAllScheduleJobs(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/scheduling-all";
        }

        public static String canScheduleJob(String schedulerId) {
            return Topics.schedulerPrefix(schedulerId) + "/schedulable";
        }
    }
}

