/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scheduler;

import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import java.io.Serializable;
import java.util.List;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import org.jetlinks.rule.engine.api.worker.Worker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public interface SchedulerRpcService {
    @ServiceMethod
    public Mono<String> getId();

    @ServiceMethod
    public Flux<WorkerInfo> getWorkers();

    @ServiceMethod
    public Mono<WorkerInfo> getWorker(String var1);

    @ServiceMethod
    public Flux<TaskInfo> schedule(ScheduleJob var1);

    @ServiceMethod
    public Mono<Void> shutdown(String var1);

    @ServiceMethod
    public Flux<TaskInfo> getSchedulingTask(String var1);

    @ServiceMethod
    public Mono<TaskInfo> getTask(String var1);

    @ServiceMethod
    public Flux<TaskInfo> getSchedulingTasks();

    @ServiceMethod
    public Mono<Long> totalTask();

    @ServiceMethod
    public Mono<Boolean> canSchedule(ScheduleJob var1);

    @ServiceMethod
    public Mono<Void> executeTask(ExecuteTaskRequest var1);

    @ServiceMethod
    public Mono<Task.State> getTaskState(String var1);

    @ServiceMethod
    public Mono<Void> taskOperation(OperateTaskRequest var1);

    @ServiceMethod
    public Mono<Void> setTaskJob(TaskJobRequest var1);

    @ServiceMethod
    public Mono<Long> getLastStateTime(String var1);

    @ServiceMethod
    public Mono<Long> getStartTime(String var1);

    @ServiceMethod
    public Mono<TaskInfo> createTask(CreateTaskRequest var1);

    @ServiceMethod
    public Mono<List<String>> getSupportExecutors(String var1);

    @ServiceMethod
    public Mono<Worker.State> getWorkerState(String var1);

    @ServiceMethod
    public Mono<Boolean> isAlive();

    @ServiceMethod
    public Mono<TaskSnapshot> dumpTask(String var1);

    public static class OperateTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private TaskOperation operation;

        public String getTaskId() {
            return this.taskId;
        }

        public TaskOperation getOperation() {
            return this.operation;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setOperation(TaskOperation operation) {
            this.operation = operation;
        }

        private OperateTaskRequest(String taskId, TaskOperation operation) {
            this.taskId = taskId;
            this.operation = operation;
        }

        public static OperateTaskRequest of(String taskId, TaskOperation operation) {
            return new OperateTaskRequest(taskId, operation);
        }

        public OperateTaskRequest() {
        }
    }

    public static class ExecuteTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private RuleData data;

        public String getTaskId() {
            return this.taskId;
        }

        public RuleData getData() {
            return this.data;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setData(RuleData data) {
            this.data = data;
        }

        private ExecuteTaskRequest(String taskId, RuleData data) {
            this.taskId = taskId;
            this.data = data;
        }

        public static ExecuteTaskRequest of(String taskId, RuleData data) {
            return new ExecuteTaskRequest(taskId, data);
        }

        public ExecuteTaskRequest() {
        }
    }

    public static class TaskJobRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private ScheduleJob job;

        public String getTaskId() {
            return this.taskId;
        }

        public ScheduleJob getJob() {
            return this.job;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        private TaskJobRequest(String taskId, ScheduleJob job) {
            this.taskId = taskId;
            this.job = job;
        }

        public static TaskJobRequest of(String taskId, ScheduleJob job) {
            return new TaskJobRequest(taskId, job);
        }

        public TaskJobRequest() {
        }
    }

    public static class CreateTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String workerId;
        private ScheduleJob job;

        public String getWorkerId() {
            return this.workerId;
        }

        public ScheduleJob getJob() {
            return this.job;
        }

        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        private CreateTaskRequest(String workerId, ScheduleJob job) {
            this.workerId = workerId;
            this.job = job;
        }

        public static CreateTaskRequest of(String workerId, ScheduleJob job) {
            return new CreateTaskRequest(workerId, job);
        }

        public CreateTaskRequest() {
        }
    }

    public static enum TaskOperation {
        START,
        PAUSE,
        RELOAD,
        SHUTDOWN,
        ENABLE_DEBUG,
        DISABLE_DEBUG;

    }

    public static class TaskInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;
        private String workerId;
        private ScheduleJob job;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getWorkerId() {
            return this.workerId;
        }

        public ScheduleJob getJob() {
            return this.job;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        public TaskInfo(String id, String name, String workerId, ScheduleJob job) {
            this.id = id;
            this.name = name;
            this.workerId = workerId;
            this.job = job;
        }

        public TaskInfo() {
        }
    }

    public static class WorkerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public WorkerInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public WorkerInfo() {
        }
    }
}

