/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.worker;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.cluster.worker.ClusterExecutionContext;
import org.jetlinks.rule.engine.cluster.worker.ClusterRuleIOManager;
import org.jetlinks.rule.engine.cluster.worker.RuleIOManager;
import org.jetlinks.rule.engine.defaults.AbstractExecutionContext;
import org.jetlinks.rule.engine.defaults.DefaultTask;
import reactor.core.publisher.Mono;

public class ClusterWorker
implements Worker {
    private final Map<String, TaskExecutorProvider> executors = new ConcurrentHashMap<String, TaskExecutorProvider>();
    private final String id;
    private final String name;
    private final EventBus eventBus;
    private final RuleIOManager ruleIOManager;

    public ClusterWorker(String id, String name, EventBus eventBus, ClusterManager clusterManager, ConditionEvaluator evaluator) {
        this(id, name, eventBus, new ClusterRuleIOManager(clusterManager, evaluator));
    }

    public ClusterWorker(String id, String name, EventBus eventBus, RuleIOManager ioManager) {
        this.id = id;
        this.name = name;
        this.eventBus = eventBus;
        this.ruleIOManager = ioManager;
    }

    public Mono<Task> createTask(String schedulerId, ScheduleJob job) {
        return (Mono)Mono.justOrEmpty((Object)this.executors.get(job.getExecutor())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("unsupported executor:" + job.getExecutor()))).flatMap(provider -> {
            ClusterExecutionContext context = this.createContext(job);
            return provider.createTask((ExecutionContext)context).map(executor -> new DefaultTask(schedulerId, this.getId(), (AbstractExecutionContext)context, executor));
        }).as((Function)RuleConstants.Trace.traceMono((ScheduleJob)job, (String)"create", (_job, builder) -> {
            builder.setAttribute(RuleConstants.Trace.executor, (Object)_job.getExecutor());
            builder.setAttributeLazy(RuleConstants.Trace.configuration, () -> JSON.toJSONString((Object)_job.getConfiguration()));
        }));
    }

    protected ClusterExecutionContext createContext(ScheduleJob job) {
        return new ClusterExecutionContext(this.getId(), job, this.eventBus, this.ruleIOManager);
    }

    public Mono<List<String>> getSupportExecutors() {
        return Mono.just(new ArrayList<String>(this.executors.keySet()));
    }

    public Mono<Worker.State> getState() {
        return Mono.just((Object)Worker.State.working);
    }

    public void addExecutor(TaskExecutorProvider provider) {
        this.executors.put(provider.getExecutor(), provider);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

