/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.worker;

import java.util.stream.Collectors;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.Slf4jLogger;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scope.GlobalScope;
import org.jetlinks.rule.engine.api.task.CompositeOutput;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.cluster.scope.ClusterGlobalScope;
import org.jetlinks.rule.engine.cluster.worker.QueueEventOutput;
import org.jetlinks.rule.engine.cluster.worker.QueueInput;
import org.jetlinks.rule.engine.cluster.worker.QueueOutput;
import org.jetlinks.rule.engine.cluster.worker.RuleIOManager;
import org.jetlinks.rule.engine.defaults.AbstractExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterExecutionContext
extends AbstractExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(ClusterExecutionContext.class);

    public ClusterExecutionContext(String workerId, ScheduleJob scheduleJob, EventBus eventBus, ClusterManager clusterManager, ConditionEvaluator evaluator) {
        super(workerId, scheduleJob, eventBus, (org.jetlinks.rule.engine.api.Logger)new Slf4jLogger("rule.engine." + scheduleJob.getInstanceId() + "." + scheduleJob.getNodeId()), job -> new QueueInput(job.getInstanceId(), job.getNodeId(), clusterManager), job -> new QueueOutput(job.getInstanceId(), clusterManager, job.getOutputs(), evaluator), job -> job.getEventOutputs().stream().map(event -> new QueueEventOutput(job.getInstanceId(), clusterManager, event.getType(), event.getSource())).collect(Collectors.groupingBy(QueueEventOutput::getEvent, Collectors.collectingAndThen(Collectors.toList(), CompositeOutput::of))), (GlobalScope)new ClusterGlobalScope(clusterManager));
    }

    public ClusterExecutionContext(String workerId, ScheduleJob scheduleJob, EventBus eventBus, RuleIOManager manager) {
        super(workerId, scheduleJob, eventBus, (org.jetlinks.rule.engine.api.Logger)new Slf4jLogger("rule.engine." + scheduleJob.getInstanceId() + "." + scheduleJob.getNodeId()), manager::createInput, manager::createOutput, manager::createEvent, manager.createScope());
    }
}

