/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.worker;

import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scope.GlobalScope;
import org.jetlinks.rule.engine.api.task.CompositeOutput;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.Input;
import org.jetlinks.rule.engine.api.task.Output;
import org.jetlinks.rule.engine.cluster.scope.ClusterGlobalScope;
import org.jetlinks.rule.engine.cluster.worker.QueueEventOutput;
import org.jetlinks.rule.engine.cluster.worker.QueueInput;
import org.jetlinks.rule.engine.cluster.worker.QueueOutput;
import org.jetlinks.rule.engine.cluster.worker.RuleIOManager;

public class ClusterRuleIOManager
implements RuleIOManager {
    private final ClusterManager clusterManager;
    private final ConditionEvaluator evaluator;

    @Override
    public Input createInput(ScheduleJob job) {
        return new QueueInput(job.getInstanceId(), job.getNodeId(), this.clusterManager);
    }

    @Override
    public Output createOutput(ScheduleJob job) {
        return new QueueOutput(job.getInstanceId(), this.clusterManager, job.getOutputs(), this.evaluator);
    }

    @Override
    public Map<String, Output> createEvent(ScheduleJob job) {
        return job.getEventOutputs().stream().map(event -> new QueueEventOutput(job.getInstanceId(), this.clusterManager, event.getType(), event.getSource())).collect(Collectors.groupingBy(QueueEventOutput::getEvent, Collectors.collectingAndThen(Collectors.toList(), CompositeOutput::of)));
    }

    @Override
    public GlobalScope createScope() {
        return new ClusterGlobalScope(this.clusterManager);
    }

    public ClusterRuleIOManager(ClusterManager clusterManager, ConditionEvaluator evaluator) {
        this.clusterManager = clusterManager;
        this.evaluator = evaluator;
    }
}

