/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.supports.official.JetLinksDeviceFunctionMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public interface SchedulerRpcService {
    @ServiceMethod
    public Mono<String> getId();

    @ServiceMethod
    public Flux<WorkerInfo> getWorkers();

    @ServiceMethod
    public Mono<WorkerInfo> getWorker(String var1);

    @ServiceMethod
    public Flux<TaskInfo> schedule(ScheduleJob var1);

    @ServiceMethod
    public Mono<Void> shutdown(String var1);

    @ServiceMethod
    public Flux<TaskInfo> getSchedulingTask(String var1);

    @ServiceMethod
    public Mono<TaskInfo> getTask(String var1);

    @ServiceMethod
    public Flux<TaskInfo> getSchedulingTasks();

    @ServiceMethod
    public Mono<Long> totalTask();

    @ServiceMethod
    public Mono<Boolean> canSchedule(ScheduleJob var1);

    @ServiceMethod
    public Mono<Void> executeTask(ExecuteTaskRequest var1);

    @ServiceMethod
    public Mono<Task.State> getTaskState(String var1);

    @ServiceMethod
    public Mono<Void> taskOperation(OperateTaskRequest var1);

    @ServiceMethod
    public Mono<Void> setTaskJob(TaskJobRequest var1);

    @ServiceMethod
    public Mono<Long> getLastStateTime(String var1);

    @ServiceMethod
    public Mono<Long> getStartTime(String var1);

    @ServiceMethod
    public Mono<TaskInfo> createTask(CreateTaskRequest var1);

    @ServiceMethod
    public Mono<List<String>> getSupportExecutors(String var1);

    @ServiceMethod
    public Mono<Worker.State> getWorkerState(String var1);

    @ServiceMethod
    public Mono<Boolean> isAlive();

    @ServiceMethod
    public Mono<TaskSnapshot> dumpTask(String var1);

    @ServiceMethod
    public Mono<FunctionMetadataInfo> getMetadata(String var1);

    public static class OperateTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private TaskOperation operation;

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public TaskOperation getOperation() {
            return this.operation;
        }

        @Generated
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Generated
        public void setOperation(TaskOperation operation) {
            this.operation = operation;
        }

        @Generated
        private OperateTaskRequest(String taskId, TaskOperation operation) {
            this.taskId = taskId;
            this.operation = operation;
        }

        @Generated
        public static OperateTaskRequest of(String taskId, TaskOperation operation) {
            return new OperateTaskRequest(taskId, operation);
        }

        @Generated
        public OperateTaskRequest() {
        }
    }

    public static class ExecuteTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private RuleData data;

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public RuleData getData() {
            return this.data;
        }

        @Generated
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Generated
        public void setData(RuleData data) {
            this.data = data;
        }

        @Generated
        private ExecuteTaskRequest(String taskId, RuleData data) {
            this.taskId = taskId;
            this.data = data;
        }

        @Generated
        public static ExecuteTaskRequest of(String taskId, RuleData data) {
            return new ExecuteTaskRequest(taskId, data);
        }

        @Generated
        public ExecuteTaskRequest() {
        }
    }

    public static class TaskJobRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String taskId;
        private ScheduleJob job;

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public ScheduleJob getJob() {
            return this.job;
        }

        @Generated
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Generated
        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        @Generated
        private TaskJobRequest(String taskId, ScheduleJob job) {
            this.taskId = taskId;
            this.job = job;
        }

        @Generated
        public static TaskJobRequest of(String taskId, ScheduleJob job) {
            return new TaskJobRequest(taskId, job);
        }

        @Generated
        public TaskJobRequest() {
        }
    }

    public static class CreateTaskRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String workerId;
        private ScheduleJob job;

        @Generated
        public String getWorkerId() {
            return this.workerId;
        }

        @Generated
        public ScheduleJob getJob() {
            return this.job;
        }

        @Generated
        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Generated
        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        @Generated
        private CreateTaskRequest(String workerId, ScheduleJob job) {
            this.workerId = workerId;
            this.job = job;
        }

        @Generated
        public static CreateTaskRequest of(String workerId, ScheduleJob job) {
            return new CreateTaskRequest(workerId, job);
        }

        @Generated
        public CreateTaskRequest() {
        }
    }

    public static enum TaskOperation {
        START,
        PAUSE,
        RELOAD,
        SHUTDOWN,
        ENABLE_DEBUG,
        DISABLE_DEBUG;

    }

    public static class TaskInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;
        private String workerId;
        private ScheduleJob job;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getWorkerId() {
            return this.workerId;
        }

        @Generated
        public ScheduleJob getJob() {
            return this.job;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Generated
        public void setJob(ScheduleJob job) {
            this.job = job;
        }

        @Generated
        public TaskInfo(String id, String name, String workerId, ScheduleJob job) {
            this.id = id;
            this.name = name;
            this.workerId = workerId;
            this.job = job;
        }

        @Generated
        public TaskInfo() {
        }
    }

    public static class WorkerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public WorkerInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Generated
        public WorkerInfo() {
        }
    }

    public static class FunctionMetadataInfo
    implements Externalizable {
        private FunctionMetadata metadata;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            SerializeUtils.writeKeyValue((Map)new JetLinksDeviceFunctionMetadata(this.metadata).toJson(), (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.metadata = new JetLinksDeviceFunctionMetadata();
            this.metadata.fromJson(new JSONObject(SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize)));
        }

        @Generated
        public FunctionMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public void setMetadata(FunctionMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        public FunctionMetadataInfo(FunctionMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        public FunctionMetadataInfo() {
        }
    }
}

