/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.worker;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.monitor.DefaultMonitor;
import org.jetlinks.core.monitor.Monitor;
import org.jetlinks.core.monitor.logger.Logger;
import org.jetlinks.core.monitor.metrics.Metrics;
import org.jetlinks.core.monitor.recorder.AbstractActionRecorder;
import org.jetlinks.core.monitor.recorder.ActionRecord;
import org.jetlinks.core.monitor.recorder.ActionRecorder;
import org.jetlinks.core.monitor.recorder.Recorder;
import org.jetlinks.core.monitor.tracer.SimpleTracer;
import org.jetlinks.core.monitor.tracer.Tracer;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.rule.engine.api.CompositeLogger;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.Slf4jLogger;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.cluster.monitor.TaskActionRecord;
import org.jetlinks.rule.engine.cluster.worker.RuleMonitorManager;
import org.jetlinks.rule.engine.defaults.EventLogger;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class DefaultRuleMonitorManager
implements RuleMonitorManager {
    protected final String workerId;
    protected final EventBus eventBus;

    @Override
    public Monitor createMonitor(ScheduleJob job) {
        return new DefaultMonitor((Logger)this.createLogger(job), this.createTracer(job), this.createMetrics(job), this.createRecorder(job));
    }

    protected Metrics createMetrics(ScheduleJob job) {
        return Metrics.noop();
    }

    protected Tracer createTracer(ScheduleJob job) {
        return new SimpleTracer((SeparatedCharSequence)this.createSpanName(job));
    }

    protected org.jetlinks.rule.engine.api.Logger createLogger(ScheduleJob job) {
        EventLogger logger = new EventLogger(this.eventBus, job.getInstanceId(), job.getNodeId(), this.workerId);
        if (Slf4jLogger.isEnabled()) {
            logger = CompositeLogger.of((org.jetlinks.rule.engine.api.Logger[])new org.jetlinks.rule.engine.api.Logger[]{logger, new Slf4jLogger((CharSequence)logger.getName())});
        }
        return logger;
    }

    protected Recorder createRecorder(ScheduleJob job) {
        boolean enabled = job.getRuleConfiguration("enableRecorder").map(arg_0 -> ((BooleanType)BooleanType.GLOBAL).convert(arg_0)).orElse(false);
        if (!enabled) {
            return Recorder.noop();
        }
        return new TaskRecorder(this.eventBus, job);
    }

    protected SharedPathString createSpanName(ScheduleJob job) {
        return SharedPathString.of((String[])new String[]{"", "rule-runtime", (String)RecyclerUtils.intern((Object)job.getExecutor()), (String)RecyclerUtils.intern((Object)job.getInstanceId()), (String)RecyclerUtils.intern((Object)job.getNodeId())});
    }

    @Generated
    public DefaultRuleMonitorManager(String workerId, EventBus eventBus) {
        this.workerId = workerId;
        this.eventBus = eventBus;
    }

    protected static class TaskRecorder
    implements Recorder {
        final EventBus eventBus;
        final ScheduleJob job;

        TaskRecorder(EventBus eventBus, ScheduleJob job) {
            this.eventBus = eventBus;
            this.job = job;
        }

        public <E> ActionRecorder<E> action(@Nonnull CharSequence action) {
            return new TaskActionRecorder(Objects.requireNonNull(action, "action can not be null"), this.eventBus, this.job);
        }
    }

    protected static class TaskActionRecorder<E>
    extends AbstractActionRecorder<E> {
        private final EventBus eventBus;
        private final ScheduleJob job;
        private ContextView ctx;

        public TaskActionRecorder(CharSequence name, EventBus eventBus, ScheduleJob job) {
            super(name);
            this.eventBus = eventBus;
            this.job = job;
        }

        public TaskActionRecorder(CharSequence name, String parentId, EventBus eventBus, ScheduleJob job) {
            super(name, parentId);
            this.eventBus = eventBus;
            this.job = job;
        }

        protected ActionRecord newRecord() {
            return new TaskActionRecord();
        }

        protected void handle(ActionRecord record) {
            TaskActionRecord _record = (TaskActionRecord)record;
            _record.setExecutor(this.job.getExecutor());
            _record.setInstanceId(this.job.getInstanceId());
            _record.setNodeId(this.job.getNodeId());
            _record.setNodeName(this.job.getName());
            this.eventBus.publish(RuleConstants.Topics.action((String)this.job.getInstanceId(), (String)this.job.getNodeId(), (CharSequence)record.getAction()), (Object)record).subscribe(null, null, null, Context.of((ContextView)this.ctx));
        }

        public ActionRecorder<E> start(ContextView context) {
            this.ctx = context;
            return super.start(context);
        }

        public <T> ActionRecorder<T> child(CharSequence action) {
            return new TaskActionRecorder<E>(action, this.record.getId(), this.eventBus, this.job).tag("_contextId", MapUtils.getString((Map)this.record.getTags(), (Object)"_contextId"));
        }
    }
}

